/*
* hal_pnl_reg.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/


#ifndef __HAL_PNL_REG_H__
#define __HAL_PNL_REG_H__

#define REG_LPLL_BASE           0x103300UL
#define REG_CHIPTOP_BASE        0x101E00UL
#define REG_CLKGEN_BASE         0x103800UL

#define REG_SCL0_BASE       0x121800
#define REG_SCL1_BASE       0x121900
#define REG_SCL2_BASE       0x121A00

#ifndef REG_TABLE_END
#define REG_TABLE_END       0xFFFF
#endif


#define BIT0                           0x00000001
#define BIT1                           0x00000002
#define BIT2                           0x00000004
#define BIT3                           0x00000008
#define BIT4                           0x00000010
#define BIT5                           0x00000020
#define BIT6                           0x00000040
#define BIT7                           0x00000080
#define BIT8                           0x00000100
#define BIT9                           0x00000200
#define BIT10                          0x00000400
#define BIT11                          0x00000800
#define BIT12                          0x00001000
#define BIT13                          0x00002000
#define BIT14                          0x00004000
#define BIT15                          0x00008000
#define BIT16                          0x00010000
#define BIT17                          0x00020000
#define BIT18                          0x00040000
#define BIT19                          0x00080000
#define BIT20                          0x00100000
#define BIT21                          0x00200000
#define BIT22                          0x00400000
#define BIT23                          0x00800000
#define BIT24                          0x01000000
#define BIT25                          0x02000000
#define BIT26                          0x04000000
#define BIT27                          0x08000000
#define BIT28                          0x10000000
#define BIT29                          0x20000000
#define BIT30                          0x40000000
#define BIT31                          0x80000000

//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
#define REG_CHIPTOP_00_L     (REG_CHIPTOP_BASE + 0x00)
#define REG_CHIPTOP_00_H     (REG_CHIPTOP_BASE + 0x01)
#define REG_CHIPTOP_01_L     (REG_CHIPTOP_BASE + 0x02)
#define REG_CHIPTOP_01_H     (REG_CHIPTOP_BASE + 0x03)
#define REG_CHIPTOP_02_L     (REG_CHIPTOP_BASE + 0x04)
#define REG_CHIPTOP_02_H     (REG_CHIPTOP_BASE + 0x05)
#define REG_CHIPTOP_03_L     (REG_CHIPTOP_BASE + 0x06)
#define REG_CHIPTOP_03_H     (REG_CHIPTOP_BASE + 0x07)
#define REG_CHIPTOP_04_L     (REG_CHIPTOP_BASE + 0x08)
#define REG_CHIPTOP_04_H     (REG_CHIPTOP_BASE + 0x09)
#define REG_CHIPTOP_05_L     (REG_CHIPTOP_BASE + 0x0A)
#define REG_CHIPTOP_05_H     (REG_CHIPTOP_BASE + 0x0B)
#define REG_CHIPTOP_06_L     (REG_CHIPTOP_BASE + 0x0C)
#define REG_CHIPTOP_06_H     (REG_CHIPTOP_BASE + 0x0D)
#define REG_CHIPTOP_07_L     (REG_CHIPTOP_BASE + 0x0E)
#define REG_CHIPTOP_07_H     (REG_CHIPTOP_BASE + 0x0F)
#define REG_CHIPTOP_08_L     (REG_CHIPTOP_BASE + 0x10)
#define REG_CHIPTOP_08_H     (REG_CHIPTOP_BASE + 0x11)
#define REG_CHIPTOP_09_L     (REG_CHIPTOP_BASE + 0x12)
#define REG_CHIPTOP_09_H     (REG_CHIPTOP_BASE + 0x13)
#define REG_CHIPTOP_0A_L     (REG_CHIPTOP_BASE + 0x14)
#define REG_CHIPTOP_0A_H     (REG_CHIPTOP_BASE + 0x15)
#define REG_CHIPTOP_0B_L     (REG_CHIPTOP_BASE + 0x16)
#define REG_CHIPTOP_0B_H     (REG_CHIPTOP_BASE + 0x17)
#define REG_CHIPTOP_0C_L     (REG_CHIPTOP_BASE + 0x18)
#define REG_CHIPTOP_0C_H     (REG_CHIPTOP_BASE + 0x19)
#define REG_CHIPTOP_0D_L     (REG_CHIPTOP_BASE + 0x1A)
#define REG_CHIPTOP_0D_H     (REG_CHIPTOP_BASE + 0x1B)
#define REG_CHIPTOP_0E_L     (REG_CHIPTOP_BASE + 0x1C)
#define REG_CHIPTOP_0E_H     (REG_CHIPTOP_BASE + 0x1D)
#define REG_CHIPTOP_0F_L     (REG_CHIPTOP_BASE + 0x1E)
#define REG_CHIPTOP_0F_H     (REG_CHIPTOP_BASE + 0x1F)
#define REG_CHIPTOP_10_L     (REG_CHIPTOP_BASE + 0x20)
#define REG_CHIPTOP_10_H     (REG_CHIPTOP_BASE + 0x21)
#define REG_CHIPTOP_11_L     (REG_CHIPTOP_BASE + 0x22)
#define REG_CHIPTOP_11_H     (REG_CHIPTOP_BASE + 0x23)
#define REG_CHIPTOP_12_L     (REG_CHIPTOP_BASE + 0x24)
#define REG_CHIPTOP_12_H     (REG_CHIPTOP_BASE + 0x25)
#define REG_CHIPTOP_13_L     (REG_CHIPTOP_BASE + 0x26)
#define REG_CHIPTOP_13_H     (REG_CHIPTOP_BASE + 0x27)
#define REG_CHIPTOP_14_L     (REG_CHIPTOP_BASE + 0x28)
#define REG_CHIPTOP_14_H     (REG_CHIPTOP_BASE + 0x29)
#define REG_CHIPTOP_15_L     (REG_CHIPTOP_BASE + 0x2A)
#define REG_CHIPTOP_15_H     (REG_CHIPTOP_BASE + 0x2B)
#define REG_CHIPTOP_16_L     (REG_CHIPTOP_BASE + 0x2C)
#define REG_CHIPTOP_16_H     (REG_CHIPTOP_BASE + 0x2D)
#define REG_CHIPTOP_17_L     (REG_CHIPTOP_BASE + 0x2E)
#define REG_CHIPTOP_17_H     (REG_CHIPTOP_BASE + 0x2F)
#define REG_CHIPTOP_18_L     (REG_CHIPTOP_BASE + 0x30)
#define REG_CHIPTOP_18_H     (REG_CHIPTOP_BASE + 0x31)
#define REG_CHIPTOP_19_L     (REG_CHIPTOP_BASE + 0x32)
#define REG_CHIPTOP_19_H     (REG_CHIPTOP_BASE + 0x33)
#define REG_CHIPTOP_1A_L     (REG_CHIPTOP_BASE + 0x34)
#define REG_CHIPTOP_1A_H     (REG_CHIPTOP_BASE + 0x35)
#define REG_CHIPTOP_1B_L     (REG_CHIPTOP_BASE + 0x36)
#define REG_CHIPTOP_1B_H     (REG_CHIPTOP_BASE + 0x37)
#define REG_CHIPTOP_1C_L     (REG_CHIPTOP_BASE + 0x38)
#define REG_CHIPTOP_1C_H     (REG_CHIPTOP_BASE + 0x39)
#define REG_CHIPTOP_1D_L     (REG_CHIPTOP_BASE + 0x3A)
#define REG_CHIPTOP_1D_H     (REG_CHIPTOP_BASE + 0x3B)
#define REG_CHIPTOP_1E_L     (REG_CHIPTOP_BASE + 0x3C)
#define REG_CHIPTOP_1E_H     (REG_CHIPTOP_BASE + 0x3D)
#define REG_CHIPTOP_1F_L     (REG_CHIPTOP_BASE + 0x3E)
#define REG_CHIPTOP_1F_H     (REG_CHIPTOP_BASE + 0x3F)
#define REG_CHIPTOP_20_L     (REG_CHIPTOP_BASE + 0x40)
#define REG_CHIPTOP_20_H     (REG_CHIPTOP_BASE + 0x41)
#define REG_CHIPTOP_21_L     (REG_CHIPTOP_BASE + 0x42)
#define REG_CHIPTOP_21_H     (REG_CHIPTOP_BASE + 0x43)
#define REG_CHIPTOP_22_L     (REG_CHIPTOP_BASE + 0x44)
#define REG_CHIPTOP_22_H     (REG_CHIPTOP_BASE + 0x45)
#define REG_CHIPTOP_23_L     (REG_CHIPTOP_BASE + 0x46)
#define REG_CHIPTOP_23_H     (REG_CHIPTOP_BASE + 0x47)
#define REG_CHIPTOP_24_L     (REG_CHIPTOP_BASE + 0x48)
#define REG_CHIPTOP_24_H     (REG_CHIPTOP_BASE + 0x49)
#define REG_CHIPTOP_25_L     (REG_CHIPTOP_BASE + 0x4A)
#define REG_CHIPTOP_25_H     (REG_CHIPTOP_BASE + 0x4B)
#define REG_CHIPTOP_26_L     (REG_CHIPTOP_BASE + 0x4C)
#define REG_CHIPTOP_26_H     (REG_CHIPTOP_BASE + 0x4D)
#define REG_CHIPTOP_27_L     (REG_CHIPTOP_BASE + 0x4E)
#define REG_CHIPTOP_27_H     (REG_CHIPTOP_BASE + 0x4F)
#define REG_CHIPTOP_28_L     (REG_CHIPTOP_BASE + 0x50)
#define REG_CHIPTOP_28_H     (REG_CHIPTOP_BASE + 0x51)
#define REG_CHIPTOP_29_L     (REG_CHIPTOP_BASE + 0x52)
#define REG_CHIPTOP_29_H     (REG_CHIPTOP_BASE + 0x53)
#define REG_CHIPTOP_2A_L     (REG_CHIPTOP_BASE + 0x54)
#define REG_CHIPTOP_2A_H     (REG_CHIPTOP_BASE + 0x55)
#define REG_CHIPTOP_2B_L     (REG_CHIPTOP_BASE + 0x56)
#define REG_CHIPTOP_2B_H     (REG_CHIPTOP_BASE + 0x57)
#define REG_CHIPTOP_2C_L     (REG_CHIPTOP_BASE + 0x58)
#define REG_CHIPTOP_2C_H     (REG_CHIPTOP_BASE + 0x59)
#define REG_CHIPTOP_2D_L     (REG_CHIPTOP_BASE + 0x5A)
#define REG_CHIPTOP_2D_H     (REG_CHIPTOP_BASE + 0x5B)
#define REG_CHIPTOP_2E_L     (REG_CHIPTOP_BASE + 0x5C)
#define REG_CHIPTOP_2E_H     (REG_CHIPTOP_BASE + 0x5D)
#define REG_CHIPTOP_2F_L     (REG_CHIPTOP_BASE + 0x5E)
#define REG_CHIPTOP_2F_H     (REG_CHIPTOP_BASE + 0x5F)
#define REG_CHIPTOP_30_L     (REG_CHIPTOP_BASE + 0x60)
#define REG_CHIPTOP_30_H     (REG_CHIPTOP_BASE + 0x61)
#define REG_CHIPTOP_31_L     (REG_CHIPTOP_BASE + 0x62)
#define REG_CHIPTOP_31_H     (REG_CHIPTOP_BASE + 0x63)
#define REG_CHIPTOP_32_L     (REG_CHIPTOP_BASE + 0x64)
#define REG_CHIPTOP_32_H     (REG_CHIPTOP_BASE + 0x65)
#define REG_CHIPTOP_33_L     (REG_CHIPTOP_BASE + 0x66)
#define REG_CHIPTOP_33_H     (REG_CHIPTOP_BASE + 0x67)
#define REG_CHIPTOP_34_L     (REG_CHIPTOP_BASE + 0x68)
#define REG_CHIPTOP_34_H     (REG_CHIPTOP_BASE + 0x69)
#define REG_CHIPTOP_35_L     (REG_CHIPTOP_BASE + 0x6A)
#define REG_CHIPTOP_35_H     (REG_CHIPTOP_BASE + 0x6B)
#define REG_CHIPTOP_36_L     (REG_CHIPTOP_BASE + 0x6C)
#define REG_CHIPTOP_36_H     (REG_CHIPTOP_BASE + 0x6D)
#define REG_CHIPTOP_37_L     (REG_CHIPTOP_BASE + 0x6E)
#define REG_CHIPTOP_37_H     (REG_CHIPTOP_BASE + 0x6F)
#define REG_CHIPTOP_38_L     (REG_CHIPTOP_BASE + 0x70)
#define REG_CHIPTOP_38_H     (REG_CHIPTOP_BASE + 0x71)
#define REG_CHIPTOP_39_L     (REG_CHIPTOP_BASE + 0x72)
#define REG_CHIPTOP_39_H     (REG_CHIPTOP_BASE + 0x73)
#define REG_CHIPTOP_3A_L     (REG_CHIPTOP_BASE + 0x74)
#define REG_CHIPTOP_3A_H     (REG_CHIPTOP_BASE + 0x75)
#define REG_CHIPTOP_3B_L     (REG_CHIPTOP_BASE + 0x76)
#define REG_CHIPTOP_3B_H     (REG_CHIPTOP_BASE + 0x77)
#define REG_CHIPTOP_3C_L     (REG_CHIPTOP_BASE + 0x78)
#define REG_CHIPTOP_3C_H     (REG_CHIPTOP_BASE + 0x79)
#define REG_CHIPTOP_3D_L     (REG_CHIPTOP_BASE + 0x7A)
#define REG_CHIPTOP_3D_H     (REG_CHIPTOP_BASE + 0x7B)
#define REG_CHIPTOP_3E_L     (REG_CHIPTOP_BASE + 0x7C)
#define REG_CHIPTOP_3E_H     (REG_CHIPTOP_BASE + 0x7D)
#define REG_CHIPTOP_3F_L     (REG_CHIPTOP_BASE + 0x7E)
#define REG_CHIPTOP_3F_H     (REG_CHIPTOP_BASE + 0x7F)
#define REG_CHIPTOP_40_L     (REG_CHIPTOP_BASE + 0x80)
#define REG_CHIPTOP_40_H     (REG_CHIPTOP_BASE + 0x81)
#define REG_CHIPTOP_41_L     (REG_CHIPTOP_BASE + 0x82)
#define REG_CHIPTOP_41_H     (REG_CHIPTOP_BASE + 0x83)
#define REG_CHIPTOP_42_L     (REG_CHIPTOP_BASE + 0x84)
#define REG_CHIPTOP_42_H     (REG_CHIPTOP_BASE + 0x85)
#define REG_CHIPTOP_43_L     (REG_CHIPTOP_BASE + 0x86)
#define REG_CHIPTOP_43_H     (REG_CHIPTOP_BASE + 0x87)
#define REG_CHIPTOP_44_L     (REG_CHIPTOP_BASE + 0x88)
#define REG_CHIPTOP_44_H     (REG_CHIPTOP_BASE + 0x89)
#define REG_CHIPTOP_45_L     (REG_CHIPTOP_BASE + 0x8A)
#define REG_CHIPTOP_45_H     (REG_CHIPTOP_BASE + 0x8B)
#define REG_CHIPTOP_46_L     (REG_CHIPTOP_BASE + 0x8C)
#define REG_CHIPTOP_46_H     (REG_CHIPTOP_BASE + 0x8D)
#define REG_CHIPTOP_47_L     (REG_CHIPTOP_BASE + 0x8E)
#define REG_CHIPTOP_47_H     (REG_CHIPTOP_BASE + 0x8F)
#define REG_CHIPTOP_48_L     (REG_CHIPTOP_BASE + 0x90)
#define REG_CHIPTOP_48_H     (REG_CHIPTOP_BASE + 0x91)
#define REG_CHIPTOP_49_L     (REG_CHIPTOP_BASE + 0x92)
#define REG_CHIPTOP_49_H     (REG_CHIPTOP_BASE + 0x93)
#define REG_CHIPTOP_4A_L     (REG_CHIPTOP_BASE + 0x94)
#define REG_CHIPTOP_4A_H     (REG_CHIPTOP_BASE + 0x95)
#define REG_CHIPTOP_4B_L     (REG_CHIPTOP_BASE + 0x96)
#define REG_CHIPTOP_4B_H     (REG_CHIPTOP_BASE + 0x97)
#define REG_CHIPTOP_4C_L     (REG_CHIPTOP_BASE + 0x98)
#define REG_CHIPTOP_4C_H     (REG_CHIPTOP_BASE + 0x99)
#define REG_CHIPTOP_4D_L     (REG_CHIPTOP_BASE + 0x9A)
#define REG_CHIPTOP_4D_H     (REG_CHIPTOP_BASE + 0x9B)
#define REG_CHIPTOP_4E_L     (REG_CHIPTOP_BASE + 0x9C)
#define REG_CHIPTOP_4E_H     (REG_CHIPTOP_BASE + 0x9D)
#define REG_CHIPTOP_4F_L     (REG_CHIPTOP_BASE + 0x9E)
#define REG_CHIPTOP_4F_H     (REG_CHIPTOP_BASE + 0x9F)
#define REG_CHIPTOP_50_L     (REG_CHIPTOP_BASE + 0xA0)
#define REG_CHIPTOP_50_H     (REG_CHIPTOP_BASE + 0xA1)
#define REG_CHIPTOP_51_L     (REG_CHIPTOP_BASE + 0xA2)
#define REG_CHIPTOP_51_H     (REG_CHIPTOP_BASE + 0xA3)
#define REG_CHIPTOP_52_L     (REG_CHIPTOP_BASE + 0xA4)
#define REG_CHIPTOP_52_H     (REG_CHIPTOP_BASE + 0xA5)
#define REG_CHIPTOP_53_L     (REG_CHIPTOP_BASE + 0xA6)
#define REG_CHIPTOP_53_H     (REG_CHIPTOP_BASE + 0xA7)
#define REG_CHIPTOP_54_L     (REG_CHIPTOP_BASE + 0xA8)
#define REG_CHIPTOP_54_H     (REG_CHIPTOP_BASE + 0xA9)
#define REG_CHIPTOP_55_L     (REG_CHIPTOP_BASE + 0xAA)
#define REG_CHIPTOP_55_H     (REG_CHIPTOP_BASE + 0xAB)
#define REG_CHIPTOP_56_L     (REG_CHIPTOP_BASE + 0xAC)
#define REG_CHIPTOP_56_H     (REG_CHIPTOP_BASE + 0xAD)
#define REG_CHIPTOP_57_L     (REG_CHIPTOP_BASE + 0xAE)
#define REG_CHIPTOP_57_H     (REG_CHIPTOP_BASE + 0xAF)
#define REG_CHIPTOP_58_L     (REG_CHIPTOP_BASE + 0xB0)
#define REG_CHIPTOP_58_H     (REG_CHIPTOP_BASE + 0xB1)
#define REG_CHIPTOP_59_L     (REG_CHIPTOP_BASE + 0xB2)
#define REG_CHIPTOP_59_H     (REG_CHIPTOP_BASE + 0xB3)
#define REG_CHIPTOP_5A_L     (REG_CHIPTOP_BASE + 0xB4)
#define REG_CHIPTOP_5A_H     (REG_CHIPTOP_BASE + 0xB5)
#define REG_CHIPTOP_5B_L     (REG_CHIPTOP_BASE + 0xB6)
#define REG_CHIPTOP_5B_H     (REG_CHIPTOP_BASE + 0xB7)
#define REG_CHIPTOP_5C_L     (REG_CHIPTOP_BASE + 0xB8)
#define REG_CHIPTOP_5C_H     (REG_CHIPTOP_BASE + 0xB9)
#define REG_CHIPTOP_5D_L     (REG_CHIPTOP_BASE + 0xBA)
#define REG_CHIPTOP_5D_H     (REG_CHIPTOP_BASE + 0xBB)
#define REG_CHIPTOP_5E_L     (REG_CHIPTOP_BASE + 0xBC)
#define REG_CHIPTOP_5E_H     (REG_CHIPTOP_BASE + 0xBD)
#define REG_CHIPTOP_5F_L     (REG_CHIPTOP_BASE + 0xBE)
#define REG_CHIPTOP_5F_H     (REG_CHIPTOP_BASE + 0xBF)
#define REG_CHIPTOP_60_L     (REG_CHIPTOP_BASE + 0xC0)
#define REG_CHIPTOP_60_H     (REG_CHIPTOP_BASE + 0xC1)
#define REG_CHIPTOP_61_L     (REG_CHIPTOP_BASE + 0xC2)
#define REG_CHIPTOP_61_H     (REG_CHIPTOP_BASE + 0xC3)
#define REG_CHIPTOP_62_L     (REG_CHIPTOP_BASE + 0xC4)
#define REG_CHIPTOP_62_H     (REG_CHIPTOP_BASE + 0xC5)
#define REG_CHIPTOP_63_L     (REG_CHIPTOP_BASE + 0xC6)
#define REG_CHIPTOP_63_H     (REG_CHIPTOP_BASE + 0xC7)
#define REG_CHIPTOP_64_L     (REG_CHIPTOP_BASE + 0xC8)
#define REG_CHIPTOP_64_H     (REG_CHIPTOP_BASE + 0xC9)
#define REG_CHIPTOP_65_L     (REG_CHIPTOP_BASE + 0xCA)
#define REG_CHIPTOP_65_H     (REG_CHIPTOP_BASE + 0xCB)
#define REG_CHIPTOP_66_L     (REG_CHIPTOP_BASE + 0xCC)
#define REG_CHIPTOP_66_H     (REG_CHIPTOP_BASE + 0xCD)
#define REG_CHIPTOP_67_L     (REG_CHIPTOP_BASE + 0xCE)
#define REG_CHIPTOP_67_H     (REG_CHIPTOP_BASE + 0xCF)
#define REG_CHIPTOP_68_L     (REG_CHIPTOP_BASE + 0xD0)
#define REG_CHIPTOP_68_H     (REG_CHIPTOP_BASE + 0xD1)
#define REG_CHIPTOP_69_L     (REG_CHIPTOP_BASE + 0xD2)
#define REG_CHIPTOP_69_H     (REG_CHIPTOP_BASE + 0xD3)
#define REG_CHIPTOP_6A_L     (REG_CHIPTOP_BASE + 0xD4)
#define REG_CHIPTOP_6A_H     (REG_CHIPTOP_BASE + 0xD5)
#define REG_CHIPTOP_6B_L     (REG_CHIPTOP_BASE + 0xD6)
#define REG_CHIPTOP_6B_H     (REG_CHIPTOP_BASE + 0xD7)
#define REG_CHIPTOP_6C_L     (REG_CHIPTOP_BASE + 0xD8)
#define REG_CHIPTOP_6C_H     (REG_CHIPTOP_BASE + 0xD9)
#define REG_CHIPTOP_6D_L     (REG_CHIPTOP_BASE + 0xDA)
#define REG_CHIPTOP_6D_H     (REG_CHIPTOP_BASE + 0xDB)
#define REG_CHIPTOP_6E_L     (REG_CHIPTOP_BASE + 0xDC)
#define REG_CHIPTOP_6E_H     (REG_CHIPTOP_BASE + 0xDD)
#define REG_CHIPTOP_6F_L     (REG_CHIPTOP_BASE + 0xDE)
#define REG_CHIPTOP_6F_H     (REG_CHIPTOP_BASE + 0xDF)
#define REG_CHIPTOP_70_L     (REG_CHIPTOP_BASE + 0xE0)
#define REG_CHIPTOP_70_H     (REG_CHIPTOP_BASE + 0xE1)
#define REG_CHIPTOP_71_L     (REG_CHIPTOP_BASE + 0xE2)
#define REG_CHIPTOP_71_H     (REG_CHIPTOP_BASE + 0xE3)
#define REG_CHIPTOP_72_L     (REG_CHIPTOP_BASE + 0xE4)
#define REG_CHIPTOP_72_H     (REG_CHIPTOP_BASE + 0xE5)
#define REG_CHIPTOP_73_L     (REG_CHIPTOP_BASE + 0xE6)
#define REG_CHIPTOP_73_H     (REG_CHIPTOP_BASE + 0xE7)
#define REG_CHIPTOP_74_L     (REG_CHIPTOP_BASE + 0xE8)
#define REG_CHIPTOP_74_H     (REG_CHIPTOP_BASE + 0xE9)
#define REG_CHIPTOP_75_L     (REG_CHIPTOP_BASE + 0xEA)
#define REG_CHIPTOP_75_H     (REG_CHIPTOP_BASE + 0xEB)
#define REG_CHIPTOP_76_L     (REG_CHIPTOP_BASE + 0xEC)
#define REG_CHIPTOP_76_H     (REG_CHIPTOP_BASE + 0xED)
#define REG_CHIPTOP_77_L     (REG_CHIPTOP_BASE + 0xEE)
#define REG_CHIPTOP_77_H     (REG_CHIPTOP_BASE + 0xEF)
#define REG_CHIPTOP_78_L     (REG_CHIPTOP_BASE + 0xF0)
#define REG_CHIPTOP_78_H     (REG_CHIPTOP_BASE + 0xF1)
#define REG_CHIPTOP_79_L     (REG_CHIPTOP_BASE + 0xF2)
#define REG_CHIPTOP_79_H     (REG_CHIPTOP_BASE + 0xF3)
#define REG_CHIPTOP_7A_L     (REG_CHIPTOP_BASE + 0xF4)
#define REG_CHIPTOP_7A_H     (REG_CHIPTOP_BASE + 0xF5)
#define REG_CHIPTOP_7B_L     (REG_CHIPTOP_BASE + 0xF6)
#define REG_CHIPTOP_7B_H     (REG_CHIPTOP_BASE + 0xF7)
#define REG_CHIPTOP_7C_L     (REG_CHIPTOP_BASE + 0xF8)
#define REG_CHIPTOP_7C_H     (REG_CHIPTOP_BASE + 0xF9)
#define REG_CHIPTOP_7D_L     (REG_CHIPTOP_BASE + 0xFA)
#define REG_CHIPTOP_7D_H     (REG_CHIPTOP_BASE + 0xFB)
#define REG_CHIPTOP_7E_L     (REG_CHIPTOP_BASE + 0xFC)
#define REG_CHIPTOP_7E_H     (REG_CHIPTOP_BASE + 0xFD)
#define REG_CHIPTOP_7F_L     (REG_CHIPTOP_BASE + 0xFE)
#define REG_CHIPTOP_7F_H     (REG_CHIPTOP_BASE + 0xFF)


#define REG_LPLL_00_L    (REG_LPLL_BASE + 0x00)
#define REG_LPLL_00_H    (REG_LPLL_BASE + 0x01)
#define REG_LPLL_01_L    (REG_LPLL_BASE + 0x02)
#define REG_LPLL_01_H    (REG_LPLL_BASE + 0x03)
#define REG_LPLL_02_L    (REG_LPLL_BASE + 0x04)
#define REG_LPLL_02_H    (REG_LPLL_BASE + 0x05)
#define REG_LPLL_03_L    (REG_LPLL_BASE + 0x06)
#define REG_LPLL_03_H    (REG_LPLL_BASE + 0x07)
#define REG_LPLL_04_L    (REG_LPLL_BASE + 0x08)
#define REG_LPLL_04_H    (REG_LPLL_BASE + 0x09)
#define REG_LPLL_05_L    (REG_LPLL_BASE + 0x0A)
#define REG_LPLL_05_H    (REG_LPLL_BASE + 0x0B)
#define REG_LPLL_06_L    (REG_LPLL_BASE + 0x0C)
#define REG_LPLL_06_H    (REG_LPLL_BASE + 0x0D)
#define REG_LPLL_07_L    (REG_LPLL_BASE + 0x0E)
#define REG_LPLL_07_H    (REG_LPLL_BASE + 0x0F)
#define REG_LPLL_08_L    (REG_LPLL_BASE + 0x10)
#define REG_LPLL_08_H    (REG_LPLL_BASE + 0x11)
#define REG_LPLL_09_L    (REG_LPLL_BASE + 0x12)
#define REG_LPLL_09_H    (REG_LPLL_BASE + 0x13)
#define REG_LPLL_0A_L    (REG_LPLL_BASE + 0x14)
#define REG_LPLL_0A_H    (REG_LPLL_BASE + 0x15)
#define REG_LPLL_0B_L    (REG_LPLL_BASE + 0x16)
#define REG_LPLL_0B_H    (REG_LPLL_BASE + 0x17)
#define REG_LPLL_0C_L    (REG_LPLL_BASE + 0x18)
#define REG_LPLL_0C_H    (REG_LPLL_BASE + 0x19)
#define REG_LPLL_0D_L    (REG_LPLL_BASE + 0x1A)
#define REG_LPLL_0D_H    (REG_LPLL_BASE + 0x1B)
#define REG_LPLL_0E_L    (REG_LPLL_BASE + 0x1C)
#define REG_LPLL_0E_H    (REG_LPLL_BASE + 0x1D)
#define REG_LPLL_0F_L    (REG_LPLL_BASE + 0x1E)
#define REG_LPLL_0F_H    (REG_LPLL_BASE + 0x1F)
#define REG_LPLL_10_L    (REG_LPLL_BASE + 0x20)
#define REG_LPLL_10_H    (REG_LPLL_BASE + 0x21)
#define REG_LPLL_11_L    (REG_LPLL_BASE + 0x22)
#define REG_LPLL_11_H    (REG_LPLL_BASE + 0x23)
#define REG_LPLL_12_L    (REG_LPLL_BASE + 0x24)
#define REG_LPLL_12_H    (REG_LPLL_BASE + 0x25)
#define REG_LPLL_13_L    (REG_LPLL_BASE + 0x26)
#define REG_LPLL_13_H    (REG_LPLL_BASE + 0x27)
#define REG_LPLL_14_L    (REG_LPLL_BASE + 0x28)
#define REG_LPLL_14_H    (REG_LPLL_BASE + 0x29)
#define REG_LPLL_15_L    (REG_LPLL_BASE + 0x2A)
#define REG_LPLL_15_H    (REG_LPLL_BASE + 0x2B)
#define REG_LPLL_16_L    (REG_LPLL_BASE + 0x2C)
#define REG_LPLL_16_H    (REG_LPLL_BASE + 0x2D)
#define REG_LPLL_17_L    (REG_LPLL_BASE + 0x2E)
#define REG_LPLL_17_H    (REG_LPLL_BASE + 0x2F)
#define REG_LPLL_18_L    (REG_LPLL_BASE + 0x30)
#define REG_LPLL_18_H    (REG_LPLL_BASE + 0x31)
#define REG_LPLL_19_L    (REG_LPLL_BASE + 0x32)
#define REG_LPLL_19_H    (REG_LPLL_BASE + 0x33)
#define REG_LPLL_1A_L    (REG_LPLL_BASE + 0x34)
#define REG_LPLL_1A_H    (REG_LPLL_BASE + 0x35)
#define REG_LPLL_1B_L    (REG_LPLL_BASE + 0x36)
#define REG_LPLL_1B_H    (REG_LPLL_BASE + 0x37)
#define REG_LPLL_1C_L    (REG_LPLL_BASE + 0x38)
#define REG_LPLL_1C_H    (REG_LPLL_BASE + 0x39)
#define REG_LPLL_1D_L    (REG_LPLL_BASE + 0x3A)
#define REG_LPLL_1D_H    (REG_LPLL_BASE + 0x3B)
#define REG_LPLL_1E_L    (REG_LPLL_BASE + 0x3C)
#define REG_LPLL_1E_H    (REG_LPLL_BASE + 0x3D)
#define REG_LPLL_1F_L    (REG_LPLL_BASE + 0x3E)
#define REG_LPLL_1F_H    (REG_LPLL_BASE + 0x3F)
#define REG_LPLL_20_L    (REG_LPLL_BASE + 0x40)
#define REG_LPLL_20_H    (REG_LPLL_BASE + 0x41)
#define REG_LPLL_21_L    (REG_LPLL_BASE + 0x42)
#define REG_LPLL_21_H    (REG_LPLL_BASE + 0x43)
#define REG_LPLL_22_L    (REG_LPLL_BASE + 0x44)
#define REG_LPLL_22_H    (REG_LPLL_BASE + 0x45)
#define REG_LPLL_23_L    (REG_LPLL_BASE + 0x46)
#define REG_LPLL_23_H    (REG_LPLL_BASE + 0x47)
#define REG_LPLL_24_L    (REG_LPLL_BASE + 0x48)
#define REG_LPLL_24_H    (REG_LPLL_BASE + 0x49)
#define REG_LPLL_25_L    (REG_LPLL_BASE + 0x4A)
#define REG_LPLL_25_H    (REG_LPLL_BASE + 0x4B)
#define REG_LPLL_26_L    (REG_LPLL_BASE + 0x4C)
#define REG_LPLL_26_H    (REG_LPLL_BASE + 0x4D)
#define REG_LPLL_27_L    (REG_LPLL_BASE + 0x4E)
#define REG_LPLL_27_H    (REG_LPLL_BASE + 0x4F)
#define REG_LPLL_28_L    (REG_LPLL_BASE + 0x50)
#define REG_LPLL_28_H    (REG_LPLL_BASE + 0x51)
#define REG_LPLL_29_L    (REG_LPLL_BASE + 0x52)
#define REG_LPLL_29_H    (REG_LPLL_BASE + 0x53)
#define REG_LPLL_2A_L    (REG_LPLL_BASE + 0x54)
#define REG_LPLL_2A_H    (REG_LPLL_BASE + 0x55)
#define REG_LPLL_2B_L    (REG_LPLL_BASE + 0x56)
#define REG_LPLL_2B_H    (REG_LPLL_BASE + 0x57)
#define REG_LPLL_2C_L    (REG_LPLL_BASE + 0x58)
#define REG_LPLL_2C_H    (REG_LPLL_BASE + 0x59)
#define REG_LPLL_2D_L    (REG_LPLL_BASE + 0x5A)
#define REG_LPLL_2D_H    (REG_LPLL_BASE + 0x5B)
#define REG_LPLL_2E_L    (REG_LPLL_BASE + 0x5C)
#define REG_LPLL_2E_H    (REG_LPLL_BASE + 0x5D)
#define REG_LPLL_2F_L    (REG_LPLL_BASE + 0x5E)
#define REG_LPLL_2F_H    (REG_LPLL_BASE + 0x5F)
#define REG_LPLL_30_L    (REG_LPLL_BASE + 0x60)
#define REG_LPLL_30_H    (REG_LPLL_BASE + 0x61)
#define REG_LPLL_31_L    (REG_LPLL_BASE + 0x62)
#define REG_LPLL_31_H    (REG_LPLL_BASE + 0x63)
#define REG_LPLL_32_L    (REG_LPLL_BASE + 0x64)
#define REG_LPLL_32_H    (REG_LPLL_BASE + 0x65)
#define REG_LPLL_33_L    (REG_LPLL_BASE + 0x66)
#define REG_LPLL_33_H    (REG_LPLL_BASE + 0x67)
#define REG_LPLL_34_L    (REG_LPLL_BASE + 0x68)
#define REG_LPLL_34_H    (REG_LPLL_BASE + 0x69)
#define REG_LPLL_35_L    (REG_LPLL_BASE + 0x6A)
#define REG_LPLL_35_H    (REG_LPLL_BASE + 0x6B)
#define REG_LPLL_36_L    (REG_LPLL_BASE + 0x6C)
#define REG_LPLL_36_H    (REG_LPLL_BASE + 0x6D)
#define REG_LPLL_37_L    (REG_LPLL_BASE + 0x6E)
#define REG_LPLL_37_H    (REG_LPLL_BASE + 0x6F)
#define REG_LPLL_38_L    (REG_LPLL_BASE + 0x70)
#define REG_LPLL_38_H    (REG_LPLL_BASE + 0x71)
#define REG_LPLL_39_L    (REG_LPLL_BASE + 0x72)
#define REG_LPLL_39_H    (REG_LPLL_BASE + 0x73)
#define REG_LPLL_3A_L    (REG_LPLL_BASE + 0x74)
#define REG_LPLL_3A_H    (REG_LPLL_BASE + 0x75)
#define REG_LPLL_3B_L    (REG_LPLL_BASE + 0x76)
#define REG_LPLL_3B_H    (REG_LPLL_BASE + 0x77)
#define REG_LPLL_3C_L    (REG_LPLL_BASE + 0x78)
#define REG_LPLL_3C_H    (REG_LPLL_BASE + 0x79)
#define REG_LPLL_3D_L    (REG_LPLL_BASE + 0x7A)
#define REG_LPLL_3D_H    (REG_LPLL_BASE + 0x7B)
#define REG_LPLL_3E_L    (REG_LPLL_BASE + 0x7C)
#define REG_LPLL_3E_H    (REG_LPLL_BASE + 0x7D)
#define REG_LPLL_3F_L    (REG_LPLL_BASE + 0x7E)
#define REG_LPLL_3F_H    (REG_LPLL_BASE + 0x7F)
#define REG_LPLL_40_L    (REG_LPLL_BASE + 0x80)
#define REG_LPLL_40_H    (REG_LPLL_BASE + 0x81)
#define REG_LPLL_41_L    (REG_LPLL_BASE + 0x82)
#define REG_LPLL_41_H    (REG_LPLL_BASE + 0x83)
#define REG_LPLL_42_L    (REG_LPLL_BASE + 0x84)
#define REG_LPLL_42_H    (REG_LPLL_BASE + 0x85)
#define REG_LPLL_43_L    (REG_LPLL_BASE + 0x86)
#define REG_LPLL_43_H    (REG_LPLL_BASE + 0x87)
#define REG_LPLL_44_L    (REG_LPLL_BASE + 0x88)
#define REG_LPLL_44_H    (REG_LPLL_BASE + 0x89)
#define REG_LPLL_45_L    (REG_LPLL_BASE + 0x8A)
#define REG_LPLL_45_H    (REG_LPLL_BASE + 0x8B)
#define REG_LPLL_46_L    (REG_LPLL_BASE + 0x8C)
#define REG_LPLL_46_H    (REG_LPLL_BASE + 0x8D)
#define REG_LPLL_47_L    (REG_LPLL_BASE + 0x8E)
#define REG_LPLL_47_H    (REG_LPLL_BASE + 0x8F)
#define REG_LPLL_48_L    (REG_LPLL_BASE + 0x90)
#define REG_LPLL_48_H    (REG_LPLL_BASE + 0x91)
#define REG_LPLL_49_L    (REG_LPLL_BASE + 0x92)
#define REG_LPLL_49_H    (REG_LPLL_BASE + 0x93)
#define REG_LPLL_4A_L    (REG_LPLL_BASE + 0x94)
#define REG_LPLL_4A_H    (REG_LPLL_BASE + 0x95)
#define REG_LPLL_4B_L    (REG_LPLL_BASE + 0x96)
#define REG_LPLL_4B_H    (REG_LPLL_BASE + 0x97)
#define REG_LPLL_4C_L    (REG_LPLL_BASE + 0x98)
#define REG_LPLL_4C_H    (REG_LPLL_BASE + 0x99)
#define REG_LPLL_4D_L    (REG_LPLL_BASE + 0x9A)
#define REG_LPLL_4D_H    (REG_LPLL_BASE + 0x9B)
#define REG_LPLL_4E_L    (REG_LPLL_BASE + 0x9C)
#define REG_LPLL_4E_H    (REG_LPLL_BASE + 0x9D)
#define REG_LPLL_4F_L    (REG_LPLL_BASE + 0x9E)
#define REG_LPLL_4F_H    (REG_LPLL_BASE + 0x9F)
#define REG_LPLL_50_L    (REG_LPLL_BASE + 0xA0)
#define REG_LPLL_50_H    (REG_LPLL_BASE + 0xA1)
#define REG_LPLL_51_L    (REG_LPLL_BASE + 0xA2)
#define REG_LPLL_51_H    (REG_LPLL_BASE + 0xA3)
#define REG_LPLL_52_L    (REG_LPLL_BASE + 0xA4)
#define REG_LPLL_52_H    (REG_LPLL_BASE + 0xA5)
#define REG_LPLL_53_L    (REG_LPLL_BASE + 0xA6)
#define REG_LPLL_53_H    (REG_LPLL_BASE + 0xA7)
#define REG_LPLL_54_L    (REG_LPLL_BASE + 0xA8)
#define REG_LPLL_54_H    (REG_LPLL_BASE + 0xA9)
#define REG_LPLL_55_L    (REG_LPLL_BASE + 0xAA)
#define REG_LPLL_55_H    (REG_LPLL_BASE + 0xAB)
#define REG_LPLL_56_L    (REG_LPLL_BASE + 0xAC)
#define REG_LPLL_56_H    (REG_LPLL_BASE + 0xAD)
#define REG_LPLL_57_L    (REG_LPLL_BASE + 0xAE)
#define REG_LPLL_57_H    (REG_LPLL_BASE + 0xAF)
#define REG_LPLL_58_L    (REG_LPLL_BASE + 0xB0)
#define REG_LPLL_58_H    (REG_LPLL_BASE + 0xB1)
#define REG_LPLL_59_L    (REG_LPLL_BASE + 0xB2)
#define REG_LPLL_59_H    (REG_LPLL_BASE + 0xB3)
#define REG_LPLL_5A_L    (REG_LPLL_BASE + 0xB4)
#define REG_LPLL_5A_H    (REG_LPLL_BASE + 0xB5)
#define REG_LPLL_5B_L    (REG_LPLL_BASE + 0xB6)
#define REG_LPLL_5B_H    (REG_LPLL_BASE + 0xB7)
#define REG_LPLL_5C_L    (REG_LPLL_BASE + 0xB8)
#define REG_LPLL_5C_H    (REG_LPLL_BASE + 0xB9)
#define REG_LPLL_5D_L    (REG_LPLL_BASE + 0xBA)
#define REG_LPLL_5D_H    (REG_LPLL_BASE + 0xBB)
#define REG_LPLL_5E_L    (REG_LPLL_BASE + 0xBC)
#define REG_LPLL_5E_H    (REG_LPLL_BASE + 0xBD)
#define REG_LPLL_5F_L    (REG_LPLL_BASE + 0xBE)
#define REG_LPLL_5F_H    (REG_LPLL_BASE + 0xBF)
#define REG_LPLL_60_L    (REG_LPLL_BASE + 0xC0)
#define REG_LPLL_60_H    (REG_LPLL_BASE + 0xC1)
#define REG_LPLL_61_L    (REG_LPLL_BASE + 0xC2)
#define REG_LPLL_61_H    (REG_LPLL_BASE + 0xC3)
#define REG_LPLL_62_L    (REG_LPLL_BASE + 0xC4)
#define REG_LPLL_62_H    (REG_LPLL_BASE + 0xC5)
#define REG_LPLL_63_L    (REG_LPLL_BASE + 0xC6)
#define REG_LPLL_63_H    (REG_LPLL_BASE + 0xC7)
#define REG_LPLL_64_L    (REG_LPLL_BASE + 0xC8)
#define REG_LPLL_64_H    (REG_LPLL_BASE + 0xC9)
#define REG_LPLL_65_L    (REG_LPLL_BASE + 0xCA)
#define REG_LPLL_65_H    (REG_LPLL_BASE + 0xCB)
#define REG_LPLL_66_L    (REG_LPLL_BASE + 0xCC)
#define REG_LPLL_66_H    (REG_LPLL_BASE + 0xCD)
#define REG_LPLL_67_L    (REG_LPLL_BASE + 0xCE)
#define REG_LPLL_67_H    (REG_LPLL_BASE + 0xCF)
#define REG_LPLL_68_L    (REG_LPLL_BASE + 0xD0)
#define REG_LPLL_68_H    (REG_LPLL_BASE + 0xD1)
#define REG_LPLL_69_L    (REG_LPLL_BASE + 0xD2)
#define REG_LPLL_69_H    (REG_LPLL_BASE + 0xD3)
#define REG_LPLL_6A_L    (REG_LPLL_BASE + 0xD4)
#define REG_LPLL_6A_H    (REG_LPLL_BASE + 0xD5)
#define REG_LPLL_6B_L    (REG_LPLL_BASE + 0xD6)
#define REG_LPLL_6B_H    (REG_LPLL_BASE + 0xD7)
#define REG_LPLL_6C_L    (REG_LPLL_BASE + 0xD8)
#define REG_LPLL_6C_H    (REG_LPLL_BASE + 0xD9)
#define REG_LPLL_6D_L    (REG_LPLL_BASE + 0xDA)
#define REG_LPLL_6D_H    (REG_LPLL_BASE + 0xDB)
#define REG_LPLL_6E_L    (REG_LPLL_BASE + 0xDC)
#define REG_LPLL_6E_H    (REG_LPLL_BASE + 0xDD)
#define REG_LPLL_6F_L    (REG_LPLL_BASE + 0xDE)
#define REG_LPLL_6F_H    (REG_LPLL_BASE + 0xDF)
#define REG_LPLL_70_L    (REG_LPLL_BASE + 0xE0)
#define REG_LPLL_70_H    (REG_LPLL_BASE + 0xE1)
#define REG_LPLL_71_L    (REG_LPLL_BASE + 0xE2)
#define REG_LPLL_71_H    (REG_LPLL_BASE + 0xE3)
#define REG_LPLL_72_L    (REG_LPLL_BASE + 0xE4)
#define REG_LPLL_72_H    (REG_LPLL_BASE + 0xE5)
#define REG_LPLL_73_L    (REG_LPLL_BASE + 0xE6)
#define REG_LPLL_73_H    (REG_LPLL_BASE + 0xE7)
#define REG_LPLL_74_L    (REG_LPLL_BASE + 0xE8)
#define REG_LPLL_74_H    (REG_LPLL_BASE + 0xE9)
#define REG_LPLL_75_L    (REG_LPLL_BASE + 0xEA)
#define REG_LPLL_75_H    (REG_LPLL_BASE + 0xEB)
#define REG_LPLL_76_L    (REG_LPLL_BASE + 0xEC)
#define REG_LPLL_76_H    (REG_LPLL_BASE + 0xED)
#define REG_LPLL_77_L    (REG_LPLL_BASE + 0xEE)
#define REG_LPLL_77_H    (REG_LPLL_BASE + 0xEF)
#define REG_LPLL_78_L    (REG_LPLL_BASE + 0xF0)
#define REG_LPLL_78_H    (REG_LPLL_BASE + 0xF1)
#define REG_LPLL_79_L    (REG_LPLL_BASE + 0xF2)
#define REG_LPLL_79_H    (REG_LPLL_BASE + 0xF3)
#define REG_LPLL_7A_L    (REG_LPLL_BASE + 0xF4)
#define REG_LPLL_7A_H    (REG_LPLL_BASE + 0xF5)
#define REG_LPLL_7B_L    (REG_LPLL_BASE + 0xF6)
#define REG_LPLL_7B_H    (REG_LPLL_BASE + 0xF7)
#define REG_LPLL_7C_L    (REG_LPLL_BASE + 0xF8)
#define REG_LPLL_7C_H    (REG_LPLL_BASE + 0xF9)
#define REG_LPLL_7D_L    (REG_LPLL_BASE + 0xFA)
#define REG_LPLL_7D_H    (REG_LPLL_BASE + 0xFB)
#define REG_LPLL_7E_L    (REG_LPLL_BASE + 0xFC)
#define REG_LPLL_7E_H    (REG_LPLL_BASE + 0xFD)
#define REG_LPLL_7F_L    (REG_LPLL_BASE + 0xFE)
#define REG_LPLL_7F_H    (REG_LPLL_BASE + 0xFF)


#define REG_CLKGEN_00_L    (REG_CLKGEN_BASE + 0x00)
#define REG_CLKGEN_00_H    (REG_CLKGEN_BASE + 0x01)
#define REG_CLKGEN_01_L    (REG_CLKGEN_BASE + 0x02)
#define REG_CLKGEN_01_H    (REG_CLKGEN_BASE + 0x03)
#define REG_CLKGEN_02_L    (REG_CLKGEN_BASE + 0x04)
#define REG_CLKGEN_02_H    (REG_CLKGEN_BASE + 0x05)
#define REG_CLKGEN_03_L    (REG_CLKGEN_BASE + 0x06)
#define REG_CLKGEN_03_H    (REG_CLKGEN_BASE + 0x07)
#define REG_CLKGEN_04_L    (REG_CLKGEN_BASE + 0x08)
#define REG_CLKGEN_04_H    (REG_CLKGEN_BASE + 0x09)
#define REG_CLKGEN_05_L    (REG_CLKGEN_BASE + 0x0A)
#define REG_CLKGEN_05_H    (REG_CLKGEN_BASE + 0x0B)
#define REG_CLKGEN_06_L    (REG_CLKGEN_BASE + 0x0C)
#define REG_CLKGEN_06_H    (REG_CLKGEN_BASE + 0x0D)
#define REG_CLKGEN_07_L    (REG_CLKGEN_BASE + 0x0E)
#define REG_CLKGEN_07_H    (REG_CLKGEN_BASE + 0x0F)
#define REG_CLKGEN_08_L    (REG_CLKGEN_BASE + 0x10)
#define REG_CLKGEN_08_H    (REG_CLKGEN_BASE + 0x11)
#define REG_CLKGEN_09_L    (REG_CLKGEN_BASE + 0x12)
#define REG_CLKGEN_09_H    (REG_CLKGEN_BASE + 0x13)
#define REG_CLKGEN_0A_L    (REG_CLKGEN_BASE + 0x14)
#define REG_CLKGEN_0A_H    (REG_CLKGEN_BASE + 0x15)
#define REG_CLKGEN_0B_L    (REG_CLKGEN_BASE + 0x16)
#define REG_CLKGEN_0B_H    (REG_CLKGEN_BASE + 0x17)
#define REG_CLKGEN_0C_L    (REG_CLKGEN_BASE + 0x18)
#define REG_CLKGEN_0C_H    (REG_CLKGEN_BASE + 0x19)
#define REG_CLKGEN_0D_L    (REG_CLKGEN_BASE + 0x1A)
#define REG_CLKGEN_0D_H    (REG_CLKGEN_BASE + 0x1B)
#define REG_CLKGEN_0E_L    (REG_CLKGEN_BASE + 0x1C)
#define REG_CLKGEN_0E_H    (REG_CLKGEN_BASE + 0x1D)
#define REG_CLKGEN_0F_L    (REG_CLKGEN_BASE + 0x1E)
#define REG_CLKGEN_0F_H    (REG_CLKGEN_BASE + 0x1F)
#define REG_CLKGEN_10_L    (REG_CLKGEN_BASE + 0x20)
#define REG_CLKGEN_10_H    (REG_CLKGEN_BASE + 0x21)
#define REG_CLKGEN_11_L    (REG_CLKGEN_BASE + 0x22)
#define REG_CLKGEN_11_H    (REG_CLKGEN_BASE + 0x23)
#define REG_CLKGEN_12_L    (REG_CLKGEN_BASE + 0x24)
#define REG_CLKGEN_12_H    (REG_CLKGEN_BASE + 0x25)
#define REG_CLKGEN_13_L    (REG_CLKGEN_BASE + 0x26)
#define REG_CLKGEN_13_H    (REG_CLKGEN_BASE + 0x27)
#define REG_CLKGEN_14_L    (REG_CLKGEN_BASE + 0x28)
#define REG_CLKGEN_14_H    (REG_CLKGEN_BASE + 0x29)
#define REG_CLKGEN_15_L    (REG_CLKGEN_BASE + 0x2A)
#define REG_CLKGEN_15_H    (REG_CLKGEN_BASE + 0x2B)
#define REG_CLKGEN_16_L    (REG_CLKGEN_BASE + 0x2C)
#define REG_CLKGEN_16_H    (REG_CLKGEN_BASE + 0x2D)
#define REG_CLKGEN_17_L    (REG_CLKGEN_BASE + 0x2E)
#define REG_CLKGEN_17_H    (REG_CLKGEN_BASE + 0x2F)
#define REG_CLKGEN_18_L    (REG_CLKGEN_BASE + 0x30)
#define REG_CLKGEN_18_H    (REG_CLKGEN_BASE + 0x31)
#define REG_CLKGEN_19_L    (REG_CLKGEN_BASE + 0x32)
#define REG_CLKGEN_19_H    (REG_CLKGEN_BASE + 0x33)
#define REG_CLKGEN_1A_L    (REG_CLKGEN_BASE + 0x34)
#define REG_CLKGEN_1A_H    (REG_CLKGEN_BASE + 0x35)
#define REG_CLKGEN_1B_L    (REG_CLKGEN_BASE + 0x36)
#define REG_CLKGEN_1B_H    (REG_CLKGEN_BASE + 0x37)
#define REG_CLKGEN_1C_L    (REG_CLKGEN_BASE + 0x38)
#define REG_CLKGEN_1C_H    (REG_CLKGEN_BASE + 0x39)
#define REG_CLKGEN_1D_L    (REG_CLKGEN_BASE + 0x3A)
#define REG_CLKGEN_1D_H    (REG_CLKGEN_BASE + 0x3B)
#define REG_CLKGEN_1E_L    (REG_CLKGEN_BASE + 0x3C)
#define REG_CLKGEN_1E_H    (REG_CLKGEN_BASE + 0x3D)
#define REG_CLKGEN_1F_L    (REG_CLKGEN_BASE + 0x3E)
#define REG_CLKGEN_1F_H    (REG_CLKGEN_BASE + 0x3F)
#define REG_CLKGEN_20_L    (REG_CLKGEN_BASE + 0x40)
#define REG_CLKGEN_20_H    (REG_CLKGEN_BASE + 0x41)
#define REG_CLKGEN_21_L    (REG_CLKGEN_BASE + 0x42)
#define REG_CLKGEN_21_H    (REG_CLKGEN_BASE + 0x43)
#define REG_CLKGEN_22_L    (REG_CLKGEN_BASE + 0x44)
#define REG_CLKGEN_22_H    (REG_CLKGEN_BASE + 0x45)
#define REG_CLKGEN_23_L    (REG_CLKGEN_BASE + 0x46)
#define REG_CLKGEN_23_H    (REG_CLKGEN_BASE + 0x47)
#define REG_CLKGEN_24_L    (REG_CLKGEN_BASE + 0x48)
#define REG_CLKGEN_24_H    (REG_CLKGEN_BASE + 0x49)
#define REG_CLKGEN_25_L    (REG_CLKGEN_BASE + 0x4A)
#define REG_CLKGEN_25_H    (REG_CLKGEN_BASE + 0x4B)
#define REG_CLKGEN_26_L    (REG_CLKGEN_BASE + 0x4C)
#define REG_CLKGEN_26_H    (REG_CLKGEN_BASE + 0x4D)
#define REG_CLKGEN_27_L    (REG_CLKGEN_BASE + 0x4E)
#define REG_CLKGEN_27_H    (REG_CLKGEN_BASE + 0x4F)
#define REG_CLKGEN_28_L    (REG_CLKGEN_BASE + 0x50)
#define REG_CLKGEN_28_H    (REG_CLKGEN_BASE + 0x51)
#define REG_CLKGEN_29_L    (REG_CLKGEN_BASE + 0x52)
#define REG_CLKGEN_29_H    (REG_CLKGEN_BASE + 0x53)
#define REG_CLKGEN_2A_L    (REG_CLKGEN_BASE + 0x54)
#define REG_CLKGEN_2A_H    (REG_CLKGEN_BASE + 0x55)
#define REG_CLKGEN_2B_L    (REG_CLKGEN_BASE + 0x56)
#define REG_CLKGEN_2B_H    (REG_CLKGEN_BASE + 0x57)
#define REG_CLKGEN_2C_L    (REG_CLKGEN_BASE + 0x58)
#define REG_CLKGEN_2C_H    (REG_CLKGEN_BASE + 0x59)
#define REG_CLKGEN_2D_L    (REG_CLKGEN_BASE + 0x5A)
#define REG_CLKGEN_2D_H    (REG_CLKGEN_BASE + 0x5B)
#define REG_CLKGEN_2E_L    (REG_CLKGEN_BASE + 0x5C)
#define REG_CLKGEN_2E_H    (REG_CLKGEN_BASE + 0x5D)
#define REG_CLKGEN_2F_L    (REG_CLKGEN_BASE + 0x5E)
#define REG_CLKGEN_2F_H    (REG_CLKGEN_BASE + 0x5F)
#define REG_CLKGEN_30_L    (REG_CLKGEN_BASE + 0x60)
#define REG_CLKGEN_30_H    (REG_CLKGEN_BASE + 0x61)
#define REG_CLKGEN_31_L    (REG_CLKGEN_BASE + 0x62)
#define REG_CLKGEN_31_H    (REG_CLKGEN_BASE + 0x63)
#define REG_CLKGEN_32_L    (REG_CLKGEN_BASE + 0x64)
#define REG_CLKGEN_32_H    (REG_CLKGEN_BASE + 0x65)
#define REG_CLKGEN_33_L    (REG_CLKGEN_BASE + 0x66)
#define REG_CLKGEN_33_H    (REG_CLKGEN_BASE + 0x67)
#define REG_CLKGEN_34_L    (REG_CLKGEN_BASE + 0x68)
#define REG_CLKGEN_34_H    (REG_CLKGEN_BASE + 0x69)
#define REG_CLKGEN_35_L    (REG_CLKGEN_BASE + 0x6A)
#define REG_CLKGEN_35_H    (REG_CLKGEN_BASE + 0x6B)
#define REG_CLKGEN_36_L    (REG_CLKGEN_BASE + 0x6C)
#define REG_CLKGEN_36_H    (REG_CLKGEN_BASE + 0x6D)
#define REG_CLKGEN_37_L    (REG_CLKGEN_BASE + 0x6E)
#define REG_CLKGEN_37_H    (REG_CLKGEN_BASE + 0x6F)
#define REG_CLKGEN_38_L    (REG_CLKGEN_BASE + 0x70)
#define REG_CLKGEN_38_H    (REG_CLKGEN_BASE + 0x71)
#define REG_CLKGEN_39_L    (REG_CLKGEN_BASE + 0x72)
#define REG_CLKGEN_39_H    (REG_CLKGEN_BASE + 0x73)
#define REG_CLKGEN_3A_L    (REG_CLKGEN_BASE + 0x74)
#define REG_CLKGEN_3A_H    (REG_CLKGEN_BASE + 0x75)
#define REG_CLKGEN_3B_L    (REG_CLKGEN_BASE + 0x76)
#define REG_CLKGEN_3B_H    (REG_CLKGEN_BASE + 0x77)
#define REG_CLKGEN_3C_L    (REG_CLKGEN_BASE + 0x78)
#define REG_CLKGEN_3C_H    (REG_CLKGEN_BASE + 0x79)
#define REG_CLKGEN_3D_L    (REG_CLKGEN_BASE + 0x7A)
#define REG_CLKGEN_3D_H    (REG_CLKGEN_BASE + 0x7B)
#define REG_CLKGEN_3E_L    (REG_CLKGEN_BASE + 0x7C)
#define REG_CLKGEN_3E_H    (REG_CLKGEN_BASE + 0x7D)
#define REG_CLKGEN_3F_L    (REG_CLKGEN_BASE + 0x7E)
#define REG_CLKGEN_3F_H    (REG_CLKGEN_BASE + 0x7F)
#define REG_CLKGEN_40_L    (REG_CLKGEN_BASE + 0x80)
#define REG_CLKGEN_40_H    (REG_CLKGEN_BASE + 0x81)
#define REG_CLKGEN_41_L    (REG_CLKGEN_BASE + 0x82)
#define REG_CLKGEN_41_H    (REG_CLKGEN_BASE + 0x83)
#define REG_CLKGEN_42_L    (REG_CLKGEN_BASE + 0x84)
#define REG_CLKGEN_42_H    (REG_CLKGEN_BASE + 0x85)
#define REG_CLKGEN_43_L    (REG_CLKGEN_BASE + 0x86)
#define REG_CLKGEN_43_H    (REG_CLKGEN_BASE + 0x87)
#define REG_CLKGEN_44_L    (REG_CLKGEN_BASE + 0x88)
#define REG_CLKGEN_44_H    (REG_CLKGEN_BASE + 0x89)
#define REG_CLKGEN_45_L    (REG_CLKGEN_BASE + 0x8A)
#define REG_CLKGEN_45_H    (REG_CLKGEN_BASE + 0x8B)
#define REG_CLKGEN_46_L    (REG_CLKGEN_BASE + 0x8C)
#define REG_CLKGEN_46_H    (REG_CLKGEN_BASE + 0x8D)
#define REG_CLKGEN_47_L    (REG_CLKGEN_BASE + 0x8E)
#define REG_CLKGEN_47_H    (REG_CLKGEN_BASE + 0x8F)
#define REG_CLKGEN_48_L    (REG_CLKGEN_BASE + 0x90)
#define REG_CLKGEN_48_H    (REG_CLKGEN_BASE + 0x91)
#define REG_CLKGEN_49_L    (REG_CLKGEN_BASE + 0x92)
#define REG_CLKGEN_49_H    (REG_CLKGEN_BASE + 0x93)
#define REG_CLKGEN_4A_L    (REG_CLKGEN_BASE + 0x94)
#define REG_CLKGEN_4A_H    (REG_CLKGEN_BASE + 0x95)
#define REG_CLKGEN_4B_L    (REG_CLKGEN_BASE + 0x96)
#define REG_CLKGEN_4B_H    (REG_CLKGEN_BASE + 0x97)
#define REG_CLKGEN_4C_L    (REG_CLKGEN_BASE + 0x98)
#define REG_CLKGEN_4C_H    (REG_CLKGEN_BASE + 0x99)
#define REG_CLKGEN_4D_L    (REG_CLKGEN_BASE + 0x9A)
#define REG_CLKGEN_4D_H    (REG_CLKGEN_BASE + 0x9B)
#define REG_CLKGEN_4E_L    (REG_CLKGEN_BASE + 0x9C)
#define REG_CLKGEN_4E_H    (REG_CLKGEN_BASE + 0x9D)
#define REG_CLKGEN_4F_L    (REG_CLKGEN_BASE + 0x9E)
#define REG_CLKGEN_4F_H    (REG_CLKGEN_BASE + 0x9F)
#define REG_CLKGEN_50_L    (REG_CLKGEN_BASE + 0xA0)
#define REG_CLKGEN_50_H    (REG_CLKGEN_BASE + 0xA1)
#define REG_CLKGEN_51_L    (REG_CLKGEN_BASE + 0xA2)
#define REG_CLKGEN_51_H    (REG_CLKGEN_BASE + 0xA3)
#define REG_CLKGEN_52_L    (REG_CLKGEN_BASE + 0xA4)
#define REG_CLKGEN_52_H    (REG_CLKGEN_BASE + 0xA5)
#define REG_CLKGEN_53_L    (REG_CLKGEN_BASE + 0xA6)
#define REG_CLKGEN_53_H    (REG_CLKGEN_BASE + 0xA7)
#define REG_CLKGEN_54_L    (REG_CLKGEN_BASE + 0xA8)
#define REG_CLKGEN_54_H    (REG_CLKGEN_BASE + 0xA9)
#define REG_CLKGEN_55_L    (REG_CLKGEN_BASE + 0xAA)
#define REG_CLKGEN_55_H    (REG_CLKGEN_BASE + 0xAB)
#define REG_CLKGEN_56_L    (REG_CLKGEN_BASE + 0xAC)
#define REG_CLKGEN_56_H    (REG_CLKGEN_BASE + 0xAD)
#define REG_CLKGEN_57_L    (REG_CLKGEN_BASE + 0xAE)
#define REG_CLKGEN_57_H    (REG_CLKGEN_BASE + 0xAF)
#define REG_CLKGEN_58_L    (REG_CLKGEN_BASE + 0xB0)
#define REG_CLKGEN_58_H    (REG_CLKGEN_BASE + 0xB1)
#define REG_CLKGEN_59_L    (REG_CLKGEN_BASE + 0xB2)
#define REG_CLKGEN_59_H    (REG_CLKGEN_BASE + 0xB3)
#define REG_CLKGEN_5A_L    (REG_CLKGEN_BASE + 0xB4)
#define REG_CLKGEN_5A_H    (REG_CLKGEN_BASE + 0xB5)
#define REG_CLKGEN_5B_L    (REG_CLKGEN_BASE + 0xB6)
#define REG_CLKGEN_5B_H    (REG_CLKGEN_BASE + 0xB7)
#define REG_CLKGEN_5C_L    (REG_CLKGEN_BASE + 0xB8)
#define REG_CLKGEN_5C_H    (REG_CLKGEN_BASE + 0xB9)
#define REG_CLKGEN_5D_L    (REG_CLKGEN_BASE + 0xBA)
#define REG_CLKGEN_5D_H    (REG_CLKGEN_BASE + 0xBB)
#define REG_CLKGEN_5E_L    (REG_CLKGEN_BASE + 0xBC)
#define REG_CLKGEN_5E_H    (REG_CLKGEN_BASE + 0xBD)
#define REG_CLKGEN_5F_L    (REG_CLKGEN_BASE + 0xBE)
#define REG_CLKGEN_5F_H    (REG_CLKGEN_BASE + 0xBF)
#define REG_CLKGEN_60_L    (REG_CLKGEN_BASE + 0xC0)
#define REG_CLKGEN_60_H    (REG_CLKGEN_BASE + 0xC1)
#define REG_CLKGEN_61_L    (REG_CLKGEN_BASE + 0xC2)
#define REG_CLKGEN_61_H    (REG_CLKGEN_BASE + 0xC3)
#define REG_CLKGEN_62_L    (REG_CLKGEN_BASE + 0xC4)
#define REG_CLKGEN_62_H    (REG_CLKGEN_BASE + 0xC5)
#define REG_CLKGEN_63_L    (REG_CLKGEN_BASE + 0xC6)
#define REG_CLKGEN_63_H    (REG_CLKGEN_BASE + 0xC7)
#define REG_CLKGEN_64_L    (REG_CLKGEN_BASE + 0xC8)
#define REG_CLKGEN_64_H    (REG_CLKGEN_BASE + 0xC9)
#define REG_CLKGEN_65_L    (REG_CLKGEN_BASE + 0xCA)
#define REG_CLKGEN_65_H    (REG_CLKGEN_BASE + 0xCB)
#define REG_CLKGEN_66_L    (REG_CLKGEN_BASE + 0xCC)
#define REG_CLKGEN_66_H    (REG_CLKGEN_BASE + 0xCD)
#define REG_CLKGEN_67_L    (REG_CLKGEN_BASE + 0xCE)
#define REG_CLKGEN_67_H    (REG_CLKGEN_BASE + 0xCF)
#define REG_CLKGEN_68_L    (REG_CLKGEN_BASE + 0xD0)
#define REG_CLKGEN_68_H    (REG_CLKGEN_BASE + 0xD1)
#define REG_CLKGEN_69_L    (REG_CLKGEN_BASE + 0xD2)
#define REG_CLKGEN_69_H    (REG_CLKGEN_BASE + 0xD3)
#define REG_CLKGEN_6A_L    (REG_CLKGEN_BASE + 0xD4)
#define REG_CLKGEN_6A_H    (REG_CLKGEN_BASE + 0xD5)
#define REG_CLKGEN_6B_L    (REG_CLKGEN_BASE + 0xD6)
#define REG_CLKGEN_6B_H    (REG_CLKGEN_BASE + 0xD7)
#define REG_CLKGEN_6C_L    (REG_CLKGEN_BASE + 0xD8)
#define REG_CLKGEN_6C_H    (REG_CLKGEN_BASE + 0xD9)
#define REG_CLKGEN_6D_L    (REG_CLKGEN_BASE + 0xDA)
#define REG_CLKGEN_6D_H    (REG_CLKGEN_BASE + 0xDB)
#define REG_CLKGEN_6E_L    (REG_CLKGEN_BASE + 0xDC)
#define REG_CLKGEN_6E_H    (REG_CLKGEN_BASE + 0xDD)
#define REG_CLKGEN_6F_L    (REG_CLKGEN_BASE + 0xDE)
#define REG_CLKGEN_6F_H    (REG_CLKGEN_BASE + 0xDF)
#define REG_CLKGEN_70_L    (REG_CLKGEN_BASE + 0xE0)
#define REG_CLKGEN_70_H    (REG_CLKGEN_BASE + 0xE1)
#define REG_CLKGEN_71_L    (REG_CLKGEN_BASE + 0xE2)
#define REG_CLKGEN_71_H    (REG_CLKGEN_BASE + 0xE3)
#define REG_CLKGEN_72_L    (REG_CLKGEN_BASE + 0xE4)
#define REG_CLKGEN_72_H    (REG_CLKGEN_BASE + 0xE5)
#define REG_CLKGEN_73_L    (REG_CLKGEN_BASE + 0xE6)
#define REG_CLKGEN_73_H    (REG_CLKGEN_BASE + 0xE7)
#define REG_CLKGEN_74_L    (REG_CLKGEN_BASE + 0xE8)
#define REG_CLKGEN_74_H    (REG_CLKGEN_BASE + 0xE9)
#define REG_CLKGEN_75_L    (REG_CLKGEN_BASE + 0xEA)
#define REG_CLKGEN_75_H    (REG_CLKGEN_BASE + 0xEB)
#define REG_CLKGEN_76_L    (REG_CLKGEN_BASE + 0xEC)
#define REG_CLKGEN_76_H    (REG_CLKGEN_BASE + 0xED)
#define REG_CLKGEN_77_L    (REG_CLKGEN_BASE + 0xEE)
#define REG_CLKGEN_77_H    (REG_CLKGEN_BASE + 0xEF)
#define REG_CLKGEN_78_L    (REG_CLKGEN_BASE + 0xF0)
#define REG_CLKGEN_78_H    (REG_CLKGEN_BASE + 0xF1)
#define REG_CLKGEN_79_L    (REG_CLKGEN_BASE + 0xF2)
#define REG_CLKGEN_79_H    (REG_CLKGEN_BASE + 0xF3)
#define REG_CLKGEN_7A_L    (REG_CLKGEN_BASE + 0xF4)
#define REG_CLKGEN_7A_H    (REG_CLKGEN_BASE + 0xF5)
#define REG_CLKGEN_7B_L    (REG_CLKGEN_BASE + 0xF6)
#define REG_CLKGEN_7B_H    (REG_CLKGEN_BASE + 0xF7)
#define REG_CLKGEN_7C_L    (REG_CLKGEN_BASE + 0xF8)
#define REG_CLKGEN_7C_H    (REG_CLKGEN_BASE + 0xF9)
#define REG_CLKGEN_7D_L    (REG_CLKGEN_BASE + 0xFA)
#define REG_CLKGEN_7D_H    (REG_CLKGEN_BASE + 0xFB)
#define REG_CLKGEN_7E_L    (REG_CLKGEN_BASE + 0xFC)
#define REG_CLKGEN_7E_H    (REG_CLKGEN_BASE + 0xFD)
#define REG_CLKGEN_7F_L    (REG_CLKGEN_BASE + 0xFE)
#define REG_CLKGEN_7F_H    (REG_CLKGEN_BASE + 0xFF)




#define REG_SCL0_00_L        (REG_SCL0_BASE + 0x00)
#define REG_SCL0_00_H        (REG_SCL0_BASE + 0x01)
#define REG_SCL0_01_L        (REG_SCL0_BASE + 0x02)
#define REG_SCL0_01_H        (REG_SCL0_BASE + 0x03)
#define REG_SCL0_02_L        (REG_SCL0_BASE + 0x04)
#define REG_SCL0_02_H        (REG_SCL0_BASE + 0x05)
#define REG_SCL0_03_L        (REG_SCL0_BASE + 0x06)
#define REG_SCL0_03_H        (REG_SCL0_BASE + 0x07)
#define REG_SCL0_04_L        (REG_SCL0_BASE + 0x08)
#define REG_SCL0_04_H        (REG_SCL0_BASE + 0x09)
#define REG_SCL0_05_L        (REG_SCL0_BASE + 0x0A)
#define REG_SCL0_05_H        (REG_SCL0_BASE + 0x0B)
#define REG_SCL0_06_L        (REG_SCL0_BASE + 0x0C)
#define REG_SCL0_06_H        (REG_SCL0_BASE + 0x0D)
#define REG_SCL0_07_L        (REG_SCL0_BASE + 0x0E)
#define REG_SCL0_07_H        (REG_SCL0_BASE + 0x0F)
#define REG_SCL0_08_L        (REG_SCL0_BASE + 0x10)
#define REG_SCL0_08_H        (REG_SCL0_BASE + 0x11)
#define REG_SCL0_09_L        (REG_SCL0_BASE + 0x12)
#define REG_SCL0_09_H        (REG_SCL0_BASE + 0x13)
#define REG_SCL0_0A_L        (REG_SCL0_BASE + 0x14)
#define REG_SCL0_0A_H        (REG_SCL0_BASE + 0x15)
#define REG_SCL0_0B_L        (REG_SCL0_BASE + 0x16)
#define REG_SCL0_0B_H        (REG_SCL0_BASE + 0x17)
#define REG_SCL0_0C_L        (REG_SCL0_BASE + 0x18)
#define REG_SCL0_0C_H        (REG_SCL0_BASE + 0x19)
#define REG_SCL0_0D_L        (REG_SCL0_BASE + 0x1A)
#define REG_SCL0_0D_H        (REG_SCL0_BASE + 0x1B)
#define REG_SCL0_0E_L        (REG_SCL0_BASE + 0x1C)
#define REG_SCL0_0E_H        (REG_SCL0_BASE + 0x1D)
#define REG_SCL0_0F_L        (REG_SCL0_BASE + 0x1E)
#define REG_SCL0_0F_H        (REG_SCL0_BASE + 0x1F)
#define REG_SCL0_10_L        (REG_SCL0_BASE + 0x20)
#define REG_SCL0_10_H        (REG_SCL0_BASE + 0x21)
#define REG_SCL0_11_L        (REG_SCL0_BASE + 0x22)
#define REG_SCL0_11_H        (REG_SCL0_BASE + 0x23)
#define REG_SCL0_12_L        (REG_SCL0_BASE + 0x24)
#define REG_SCL0_12_H        (REG_SCL0_BASE + 0x25)
#define REG_SCL0_13_L        (REG_SCL0_BASE + 0x26)
#define REG_SCL0_13_H        (REG_SCL0_BASE + 0x27)
#define REG_SCL0_14_L        (REG_SCL0_BASE + 0x28)
#define REG_SCL0_14_H        (REG_SCL0_BASE + 0x29)
#define REG_SCL0_15_L        (REG_SCL0_BASE + 0x2A)
#define REG_SCL0_15_H        (REG_SCL0_BASE + 0x2B)
#define REG_SCL0_16_L        (REG_SCL0_BASE + 0x2C)
#define REG_SCL0_16_H        (REG_SCL0_BASE + 0x2D)
#define REG_SCL0_17_L        (REG_SCL0_BASE + 0x2E)
#define REG_SCL0_17_H        (REG_SCL0_BASE + 0x2F)
#define REG_SCL0_18_L        (REG_SCL0_BASE + 0x30)
#define REG_SCL0_18_H        (REG_SCL0_BASE + 0x31)
#define REG_SCL0_19_L        (REG_SCL0_BASE + 0x32)
#define REG_SCL0_19_H        (REG_SCL0_BASE + 0x33)
#define REG_SCL0_1A_L        (REG_SCL0_BASE + 0x34)
#define REG_SCL0_1A_H        (REG_SCL0_BASE + 0x35)
#define REG_SCL0_1B_L        (REG_SCL0_BASE + 0x36)
#define REG_SCL0_1B_H        (REG_SCL0_BASE + 0x37)
#define REG_SCL0_1C_L        (REG_SCL0_BASE + 0x38)
#define REG_SCL0_1C_H        (REG_SCL0_BASE + 0x39)
#define REG_SCL0_1D_L        (REG_SCL0_BASE + 0x3A)
#define REG_SCL0_1D_H        (REG_SCL0_BASE + 0x3B)
#define REG_SCL0_1E_L        (REG_SCL0_BASE + 0x3C)
#define REG_SCL0_1E_H        (REG_SCL0_BASE + 0x3D)
#define REG_SCL0_1F_L        (REG_SCL0_BASE + 0x3E)
#define REG_SCL0_1F_H        (REG_SCL0_BASE + 0x3F)
#define REG_SCL0_20_L        (REG_SCL0_BASE + 0x40)
#define REG_SCL0_20_H        (REG_SCL0_BASE + 0x41)
#define REG_SCL0_21_L        (REG_SCL0_BASE + 0x42)
#define REG_SCL0_21_H        (REG_SCL0_BASE + 0x43)
#define REG_SCL0_22_L        (REG_SCL0_BASE + 0x44)
#define REG_SCL0_22_H        (REG_SCL0_BASE + 0x45)
#define REG_SCL0_23_L        (REG_SCL0_BASE + 0x46)
#define REG_SCL0_23_H        (REG_SCL0_BASE + 0x47)
#define REG_SCL0_24_L        (REG_SCL0_BASE + 0x48)
#define REG_SCL0_24_H        (REG_SCL0_BASE + 0x49)
#define REG_SCL0_25_L        (REG_SCL0_BASE + 0x4A)
#define REG_SCL0_25_H        (REG_SCL0_BASE + 0x4B)
#define REG_SCL0_26_L        (REG_SCL0_BASE + 0x4C)
#define REG_SCL0_26_H        (REG_SCL0_BASE + 0x4D)
#define REG_SCL0_27_L        (REG_SCL0_BASE + 0x4E)
#define REG_SCL0_27_H        (REG_SCL0_BASE + 0x4F)
#define REG_SCL0_28_L        (REG_SCL0_BASE + 0x50)
#define REG_SCL0_28_H        (REG_SCL0_BASE + 0x51)
#define REG_SCL0_29_L        (REG_SCL0_BASE + 0x52)
#define REG_SCL0_29_H        (REG_SCL0_BASE + 0x53)
#define REG_SCL0_2A_L        (REG_SCL0_BASE + 0x54)
#define REG_SCL0_2A_H        (REG_SCL0_BASE + 0x55)
#define REG_SCL0_2B_L        (REG_SCL0_BASE + 0x56)
#define REG_SCL0_2B_H        (REG_SCL0_BASE + 0x57)
#define REG_SCL0_2C_L        (REG_SCL0_BASE + 0x58)
#define REG_SCL0_2C_H        (REG_SCL0_BASE + 0x59)
#define REG_SCL0_2D_L        (REG_SCL0_BASE + 0x5A)
#define REG_SCL0_2D_H        (REG_SCL0_BASE + 0x5B)
#define REG_SCL0_2E_L        (REG_SCL0_BASE + 0x5C)
#define REG_SCL0_2E_H        (REG_SCL0_BASE + 0x5D)
#define REG_SCL0_2F_L        (REG_SCL0_BASE + 0x5E)
#define REG_SCL0_2F_H        (REG_SCL0_BASE + 0x5F)
#define REG_SCL0_30_L        (REG_SCL0_BASE + 0x60)
#define REG_SCL0_30_H        (REG_SCL0_BASE + 0x61)
#define REG_SCL0_31_L        (REG_SCL0_BASE + 0x62)
#define REG_SCL0_31_H        (REG_SCL0_BASE + 0x63)
#define REG_SCL0_32_L        (REG_SCL0_BASE + 0x64)
#define REG_SCL0_32_H        (REG_SCL0_BASE + 0x65)
#define REG_SCL0_33_L        (REG_SCL0_BASE + 0x66)
#define REG_SCL0_33_H        (REG_SCL0_BASE + 0x67)
#define REG_SCL0_34_L        (REG_SCL0_BASE + 0x68)
#define REG_SCL0_34_H        (REG_SCL0_BASE + 0x69)
#define REG_SCL0_35_L        (REG_SCL0_BASE + 0x6A)
#define REG_SCL0_35_H        (REG_SCL0_BASE + 0x6B)
#define REG_SCL0_36_L        (REG_SCL0_BASE + 0x6C)
#define REG_SCL0_36_H        (REG_SCL0_BASE + 0x6D)
#define REG_SCL0_37_L        (REG_SCL0_BASE + 0x6E)
#define REG_SCL0_37_H        (REG_SCL0_BASE + 0x6F)
#define REG_SCL0_38_L        (REG_SCL0_BASE + 0x70)
#define REG_SCL0_38_H        (REG_SCL0_BASE + 0x71)
#define REG_SCL0_39_L        (REG_SCL0_BASE + 0x72)
#define REG_SCL0_39_H        (REG_SCL0_BASE + 0x73)
#define REG_SCL0_3A_L        (REG_SCL0_BASE + 0x74)
#define REG_SCL0_3A_H        (REG_SCL0_BASE + 0x75)
#define REG_SCL0_3B_L        (REG_SCL0_BASE + 0x76)
#define REG_SCL0_3B_H        (REG_SCL0_BASE + 0x77)
#define REG_SCL0_3C_L        (REG_SCL0_BASE + 0x78)
#define REG_SCL0_3C_H        (REG_SCL0_BASE + 0x79)
#define REG_SCL0_3D_L        (REG_SCL0_BASE + 0x7A)
#define REG_SCL0_3D_H        (REG_SCL0_BASE + 0x7B)
#define REG_SCL0_3E_L        (REG_SCL0_BASE + 0x7C)
#define REG_SCL0_3E_H        (REG_SCL0_BASE + 0x7D)
#define REG_SCL0_3F_L        (REG_SCL0_BASE + 0x7E)
#define REG_SCL0_3F_H        (REG_SCL0_BASE + 0x7F)
#define REG_SCL0_40_L        (REG_SCL0_BASE + 0x80)
#define REG_SCL0_40_H        (REG_SCL0_BASE + 0x81)
#define REG_SCL0_41_L        (REG_SCL0_BASE + 0x82)
#define REG_SCL0_41_H        (REG_SCL0_BASE + 0x83)
#define REG_SCL0_42_L        (REG_SCL0_BASE + 0x84)
#define REG_SCL0_42_H        (REG_SCL0_BASE + 0x85)
#define REG_SCL0_43_L        (REG_SCL0_BASE + 0x86)
#define REG_SCL0_43_H        (REG_SCL0_BASE + 0x87)
#define REG_SCL0_44_L        (REG_SCL0_BASE + 0x88)
#define REG_SCL0_44_H        (REG_SCL0_BASE + 0x89)
#define REG_SCL0_45_L        (REG_SCL0_BASE + 0x8A)
#define REG_SCL0_45_H        (REG_SCL0_BASE + 0x8B)
#define REG_SCL0_46_L        (REG_SCL0_BASE + 0x8C)
#define REG_SCL0_46_H        (REG_SCL0_BASE + 0x8D)
#define REG_SCL0_47_L        (REG_SCL0_BASE + 0x8E)
#define REG_SCL0_47_H        (REG_SCL0_BASE + 0x8F)
#define REG_SCL0_48_L        (REG_SCL0_BASE + 0x90)
#define REG_SCL0_48_H        (REG_SCL0_BASE + 0x91)
#define REG_SCL0_49_L        (REG_SCL0_BASE + 0x92)
#define REG_SCL0_49_H        (REG_SCL0_BASE + 0x93)
#define REG_SCL0_4A_L        (REG_SCL0_BASE + 0x94)
#define REG_SCL0_4A_H        (REG_SCL0_BASE + 0x95)
#define REG_SCL0_4B_L        (REG_SCL0_BASE + 0x96)
#define REG_SCL0_4B_H        (REG_SCL0_BASE + 0x97)
#define REG_SCL0_4C_L        (REG_SCL0_BASE + 0x98)
#define REG_SCL0_4C_H        (REG_SCL0_BASE + 0x99)
#define REG_SCL0_4D_L        (REG_SCL0_BASE + 0x9A)
#define REG_SCL0_4D_H        (REG_SCL0_BASE + 0x9B)
#define REG_SCL0_4E_L        (REG_SCL0_BASE + 0x9C)
#define REG_SCL0_4E_H        (REG_SCL0_BASE + 0x9D)
#define REG_SCL0_4F_L        (REG_SCL0_BASE + 0x9E)
#define REG_SCL0_4F_H        (REG_SCL0_BASE + 0x9F)
#define REG_SCL0_50_L        (REG_SCL0_BASE + 0xA0)
#define REG_SCL0_50_H        (REG_SCL0_BASE + 0xA1)
#define REG_SCL0_51_L        (REG_SCL0_BASE + 0xA2)
#define REG_SCL0_51_H        (REG_SCL0_BASE + 0xA3)
#define REG_SCL0_52_L        (REG_SCL0_BASE + 0xA4)
#define REG_SCL0_52_H        (REG_SCL0_BASE + 0xA5)
#define REG_SCL0_53_L        (REG_SCL0_BASE + 0xA6)
#define REG_SCL0_53_H        (REG_SCL0_BASE + 0xA7)
#define REG_SCL0_54_L        (REG_SCL0_BASE + 0xA8)
#define REG_SCL0_54_H        (REG_SCL0_BASE + 0xA9)
#define REG_SCL0_55_L        (REG_SCL0_BASE + 0xAA)
#define REG_SCL0_55_H        (REG_SCL0_BASE + 0xAB)
#define REG_SCL0_56_L        (REG_SCL0_BASE + 0xAC)
#define REG_SCL0_56_H        (REG_SCL0_BASE + 0xAD)
#define REG_SCL0_57_L        (REG_SCL0_BASE + 0xAE)
#define REG_SCL0_57_H        (REG_SCL0_BASE + 0xAF)
#define REG_SCL0_58_L        (REG_SCL0_BASE + 0xB0)
#define REG_SCL0_58_H        (REG_SCL0_BASE + 0xB1)
#define REG_SCL0_59_L        (REG_SCL0_BASE + 0xB2)
#define REG_SCL0_59_H        (REG_SCL0_BASE + 0xB3)
#define REG_SCL0_5A_L        (REG_SCL0_BASE + 0xB4)
#define REG_SCL0_5A_H        (REG_SCL0_BASE + 0xB5)
#define REG_SCL0_5B_L        (REG_SCL0_BASE + 0xB6)
#define REG_SCL0_5B_H        (REG_SCL0_BASE + 0xB7)
#define REG_SCL0_5C_L        (REG_SCL0_BASE + 0xB8)
#define REG_SCL0_5C_H        (REG_SCL0_BASE + 0xB9)
#define REG_SCL0_5D_L        (REG_SCL0_BASE + 0xBA)
#define REG_SCL0_5D_H        (REG_SCL0_BASE + 0xBB)
#define REG_SCL0_5E_L        (REG_SCL0_BASE + 0xBC)
#define REG_SCL0_5E_H        (REG_SCL0_BASE + 0xBD)
#define REG_SCL0_5F_L        (REG_SCL0_BASE + 0xBE)
#define REG_SCL0_5F_H        (REG_SCL0_BASE + 0xBF)
#define REG_SCL0_60_L        (REG_SCL0_BASE + 0xC0)
#define REG_SCL0_60_H        (REG_SCL0_BASE + 0xC1)
#define REG_SCL0_61_L        (REG_SCL0_BASE + 0xC2)
#define REG_SCL0_61_H        (REG_SCL0_BASE + 0xC3)
#define REG_SCL0_62_L        (REG_SCL0_BASE + 0xC4)
#define REG_SCL0_62_H        (REG_SCL0_BASE + 0xC5)
#define REG_SCL0_63_L        (REG_SCL0_BASE + 0xC6)
#define REG_SCL0_63_H        (REG_SCL0_BASE + 0xC7)
#define REG_SCL0_64_L        (REG_SCL0_BASE + 0xC8)
#define REG_SCL0_64_H        (REG_SCL0_BASE + 0xC9)
#define REG_SCL0_65_L        (REG_SCL0_BASE + 0xCA)
#define REG_SCL0_65_H        (REG_SCL0_BASE + 0xCB)
#define REG_SCL0_66_L        (REG_SCL0_BASE + 0xCC)
#define REG_SCL0_66_H        (REG_SCL0_BASE + 0xCD)
#define REG_SCL0_67_L        (REG_SCL0_BASE + 0xCE)
#define REG_SCL0_67_H        (REG_SCL0_BASE + 0xCF)
#define REG_SCL0_68_L        (REG_SCL0_BASE + 0xD0)
#define REG_SCL0_68_H        (REG_SCL0_BASE + 0xD1)
#define REG_SCL0_69_L        (REG_SCL0_BASE + 0xD2)
#define REG_SCL0_69_H        (REG_SCL0_BASE + 0xD3)
#define REG_SCL0_6A_L        (REG_SCL0_BASE + 0xD4)
#define REG_SCL0_6A_H        (REG_SCL0_BASE + 0xD5)
#define REG_SCL0_6B_L        (REG_SCL0_BASE + 0xD6)
#define REG_SCL0_6B_H        (REG_SCL0_BASE + 0xD7)
#define REG_SCL0_6C_L        (REG_SCL0_BASE + 0xD8)
#define REG_SCL0_6C_H        (REG_SCL0_BASE + 0xD9)
#define REG_SCL0_6D_L        (REG_SCL0_BASE + 0xDA)
#define REG_SCL0_6D_H        (REG_SCL0_BASE + 0xDB)
#define REG_SCL0_6E_L        (REG_SCL0_BASE + 0xDC)
#define REG_SCL0_6E_H        (REG_SCL0_BASE + 0xDD)
#define REG_SCL0_6F_L        (REG_SCL0_BASE + 0xDE)
#define REG_SCL0_6F_H        (REG_SCL0_BASE + 0xDF)
#define REG_SCL0_70_L        (REG_SCL0_BASE + 0xE0)
#define REG_SCL0_70_H        (REG_SCL0_BASE + 0xE1)
#define REG_SCL0_71_L        (REG_SCL0_BASE + 0xE2)
#define REG_SCL0_71_H        (REG_SCL0_BASE + 0xE3)
#define REG_SCL0_72_L        (REG_SCL0_BASE + 0xE4)
#define REG_SCL0_72_H        (REG_SCL0_BASE + 0xE5)
#define REG_SCL0_73_L        (REG_SCL0_BASE + 0xE6)
#define REG_SCL0_73_H        (REG_SCL0_BASE + 0xE7)
#define REG_SCL0_74_L        (REG_SCL0_BASE + 0xE8)
#define REG_SCL0_74_H        (REG_SCL0_BASE + 0xE9)
#define REG_SCL0_75_L        (REG_SCL0_BASE + 0xEA)
#define REG_SCL0_75_H        (REG_SCL0_BASE + 0xEB)
#define REG_SCL0_76_L        (REG_SCL0_BASE + 0xEC)
#define REG_SCL0_76_H        (REG_SCL0_BASE + 0xED)
#define REG_SCL0_77_L        (REG_SCL0_BASE + 0xEE)
#define REG_SCL0_77_H        (REG_SCL0_BASE + 0xEF)
#define REG_SCL0_78_L        (REG_SCL0_BASE + 0xF0)
#define REG_SCL0_78_H        (REG_SCL0_BASE + 0xF1)
#define REG_SCL0_79_L        (REG_SCL0_BASE + 0xF2)
#define REG_SCL0_79_H        (REG_SCL0_BASE + 0xF3)
#define REG_SCL0_7A_L        (REG_SCL0_BASE + 0xF4)
#define REG_SCL0_7A_H        (REG_SCL0_BASE + 0xF5)
#define REG_SCL0_7B_L        (REG_SCL0_BASE + 0xF6)
#define REG_SCL0_7B_H        (REG_SCL0_BASE + 0xF7)
#define REG_SCL0_7C_L        (REG_SCL0_BASE + 0xF8)
#define REG_SCL0_7C_H        (REG_SCL0_BASE + 0xF9)
#define REG_SCL0_7D_L        (REG_SCL0_BASE + 0xFA)
#define REG_SCL0_7D_H        (REG_SCL0_BASE + 0xFB)
#define REG_SCL0_7E_L        (REG_SCL0_BASE + 0xFC)
#define REG_SCL0_7E_H        (REG_SCL0_BASE + 0xFD)
#define REG_SCL0_7F_L        (REG_SCL0_BASE + 0xFE)
#define REG_SCL0_7F_H        (REG_SCL0_BASE + 0xFF)

#define REG_SCL1_00_L        (REG_SCL1_BASE + 0x00)
#define REG_SCL1_00_H        (REG_SCL1_BASE + 0x01)
#define REG_SCL1_01_L        (REG_SCL1_BASE + 0x02)
#define REG_SCL1_01_H        (REG_SCL1_BASE + 0x03)
#define REG_SCL1_02_L        (REG_SCL1_BASE + 0x04)
#define REG_SCL1_02_H        (REG_SCL1_BASE + 0x05)
#define REG_SCL1_03_L        (REG_SCL1_BASE + 0x06)
#define REG_SCL1_03_H        (REG_SCL1_BASE + 0x07)
#define REG_SCL1_04_L        (REG_SCL1_BASE + 0x08)
#define REG_SCL1_04_H        (REG_SCL1_BASE + 0x09)
#define REG_SCL1_05_L        (REG_SCL1_BASE + 0x0A)
#define REG_SCL1_05_H        (REG_SCL1_BASE + 0x0B)
#define REG_SCL1_06_L        (REG_SCL1_BASE + 0x0C)
#define REG_SCL1_06_H        (REG_SCL1_BASE + 0x0D)
#define REG_SCL1_07_L        (REG_SCL1_BASE + 0x0E)
#define REG_SCL1_07_H        (REG_SCL1_BASE + 0x0F)
#define REG_SCL1_08_L        (REG_SCL1_BASE + 0x10)
#define REG_SCL1_08_H        (REG_SCL1_BASE + 0x11)
#define REG_SCL1_09_L        (REG_SCL1_BASE + 0x12)
#define REG_SCL1_09_H        (REG_SCL1_BASE + 0x13)
#define REG_SCL1_0A_L        (REG_SCL1_BASE + 0x14)
#define REG_SCL1_0A_H        (REG_SCL1_BASE + 0x15)
#define REG_SCL1_0B_L        (REG_SCL1_BASE + 0x16)
#define REG_SCL1_0B_H        (REG_SCL1_BASE + 0x17)
#define REG_SCL1_0C_L        (REG_SCL1_BASE + 0x18)
#define REG_SCL1_0C_H        (REG_SCL1_BASE + 0x19)
#define REG_SCL1_0D_L        (REG_SCL1_BASE + 0x1A)
#define REG_SCL1_0D_H        (REG_SCL1_BASE + 0x1B)
#define REG_SCL1_0E_L        (REG_SCL1_BASE + 0x1C)
#define REG_SCL1_0E_H        (REG_SCL1_BASE + 0x1D)
#define REG_SCL1_0F_L        (REG_SCL1_BASE + 0x1E)
#define REG_SCL1_0F_H        (REG_SCL1_BASE + 0x1F)
#define REG_SCL1_10_L        (REG_SCL1_BASE + 0x20)
#define REG_SCL1_10_H        (REG_SCL1_BASE + 0x21)
#define REG_SCL1_11_L        (REG_SCL1_BASE + 0x22)
#define REG_SCL1_11_H        (REG_SCL1_BASE + 0x23)
#define REG_SCL1_12_L        (REG_SCL1_BASE + 0x24)
#define REG_SCL1_12_H        (REG_SCL1_BASE + 0x25)
#define REG_SCL1_13_L        (REG_SCL1_BASE + 0x26)
#define REG_SCL1_13_H        (REG_SCL1_BASE + 0x27)
#define REG_SCL1_14_L        (REG_SCL1_BASE + 0x28)
#define REG_SCL1_14_H        (REG_SCL1_BASE + 0x29)
#define REG_SCL1_15_L        (REG_SCL1_BASE + 0x2A)
#define REG_SCL1_15_H        (REG_SCL1_BASE + 0x2B)
#define REG_SCL1_16_L        (REG_SCL1_BASE + 0x2C)
#define REG_SCL1_16_H        (REG_SCL1_BASE + 0x2D)
#define REG_SCL1_17_L        (REG_SCL1_BASE + 0x2E)
#define REG_SCL1_17_H        (REG_SCL1_BASE + 0x2F)
#define REG_SCL1_18_L        (REG_SCL1_BASE + 0x30)
#define REG_SCL1_18_H        (REG_SCL1_BASE + 0x31)
#define REG_SCL1_19_L        (REG_SCL1_BASE + 0x32)
#define REG_SCL1_19_H        (REG_SCL1_BASE + 0x33)
#define REG_SCL1_1A_L        (REG_SCL1_BASE + 0x34)
#define REG_SCL1_1A_H        (REG_SCL1_BASE + 0x35)
#define REG_SCL1_1B_L        (REG_SCL1_BASE + 0x36)
#define REG_SCL1_1B_H        (REG_SCL1_BASE + 0x37)
#define REG_SCL1_1C_L        (REG_SCL1_BASE + 0x38)
#define REG_SCL1_1C_H        (REG_SCL1_BASE + 0x39)
#define REG_SCL1_1D_L        (REG_SCL1_BASE + 0x3A)
#define REG_SCL1_1D_H        (REG_SCL1_BASE + 0x3B)
#define REG_SCL1_1E_L        (REG_SCL1_BASE + 0x3C)
#define REG_SCL1_1E_H        (REG_SCL1_BASE + 0x3D)
#define REG_SCL1_1F_L        (REG_SCL1_BASE + 0x3E)
#define REG_SCL1_1F_H        (REG_SCL1_BASE + 0x3F)
#define REG_SCL1_20_L        (REG_SCL1_BASE + 0x40)
#define REG_SCL1_20_H        (REG_SCL1_BASE + 0x41)
#define REG_SCL1_21_L        (REG_SCL1_BASE + 0x42)
#define REG_SCL1_21_H        (REG_SCL1_BASE + 0x43)
#define REG_SCL1_22_L        (REG_SCL1_BASE + 0x44)
#define REG_SCL1_22_H        (REG_SCL1_BASE + 0x45)
#define REG_SCL1_23_L        (REG_SCL1_BASE + 0x46)
#define REG_SCL1_23_H        (REG_SCL1_BASE + 0x47)
#define REG_SCL1_24_L        (REG_SCL1_BASE + 0x48)
#define REG_SCL1_24_H        (REG_SCL1_BASE + 0x49)
#define REG_SCL1_25_L        (REG_SCL1_BASE + 0x4A)
#define REG_SCL1_25_H        (REG_SCL1_BASE + 0x4B)
#define REG_SCL1_26_L        (REG_SCL1_BASE + 0x4C)
#define REG_SCL1_26_H        (REG_SCL1_BASE + 0x4D)
#define REG_SCL1_27_L        (REG_SCL1_BASE + 0x4E)
#define REG_SCL1_27_H        (REG_SCL1_BASE + 0x4F)
#define REG_SCL1_28_L        (REG_SCL1_BASE + 0x50)
#define REG_SCL1_28_H        (REG_SCL1_BASE + 0x51)
#define REG_SCL1_29_L        (REG_SCL1_BASE + 0x52)
#define REG_SCL1_29_H        (REG_SCL1_BASE + 0x53)
#define REG_SCL1_2A_L        (REG_SCL1_BASE + 0x54)
#define REG_SCL1_2A_H        (REG_SCL1_BASE + 0x55)
#define REG_SCL1_2B_L        (REG_SCL1_BASE + 0x56)
#define REG_SCL1_2B_H        (REG_SCL1_BASE + 0x57)
#define REG_SCL1_2C_L        (REG_SCL1_BASE + 0x58)
#define REG_SCL1_2C_H        (REG_SCL1_BASE + 0x59)
#define REG_SCL1_2D_L        (REG_SCL1_BASE + 0x5A)
#define REG_SCL1_2D_H        (REG_SCL1_BASE + 0x5B)
#define REG_SCL1_2E_L        (REG_SCL1_BASE + 0x5C)
#define REG_SCL1_2E_H        (REG_SCL1_BASE + 0x5D)
#define REG_SCL1_2F_L        (REG_SCL1_BASE + 0x5E)
#define REG_SCL1_2F_H        (REG_SCL1_BASE + 0x5F)
#define REG_SCL1_30_L        (REG_SCL1_BASE + 0x60)
#define REG_SCL1_30_H        (REG_SCL1_BASE + 0x61)
#define REG_SCL1_31_L        (REG_SCL1_BASE + 0x62)
#define REG_SCL1_31_H        (REG_SCL1_BASE + 0x63)
#define REG_SCL1_32_L        (REG_SCL1_BASE + 0x64)
#define REG_SCL1_32_H        (REG_SCL1_BASE + 0x65)
#define REG_SCL1_33_L        (REG_SCL1_BASE + 0x66)
#define REG_SCL1_33_H        (REG_SCL1_BASE + 0x67)
#define REG_SCL1_34_L        (REG_SCL1_BASE + 0x68)
#define REG_SCL1_34_H        (REG_SCL1_BASE + 0x69)
#define REG_SCL1_35_L        (REG_SCL1_BASE + 0x6A)
#define REG_SCL1_35_H        (REG_SCL1_BASE + 0x6B)
#define REG_SCL1_36_L        (REG_SCL1_BASE + 0x6C)
#define REG_SCL1_36_H        (REG_SCL1_BASE + 0x6D)
#define REG_SCL1_37_L        (REG_SCL1_BASE + 0x6E)
#define REG_SCL1_37_H        (REG_SCL1_BASE + 0x6F)
#define REG_SCL1_38_L        (REG_SCL1_BASE + 0x70)
#define REG_SCL1_38_H        (REG_SCL1_BASE + 0x71)
#define REG_SCL1_39_L        (REG_SCL1_BASE + 0x72)
#define REG_SCL1_39_H        (REG_SCL1_BASE + 0x73)
#define REG_SCL1_3A_L        (REG_SCL1_BASE + 0x74)
#define REG_SCL1_3A_H        (REG_SCL1_BASE + 0x75)
#define REG_SCL1_3B_L        (REG_SCL1_BASE + 0x76)
#define REG_SCL1_3B_H        (REG_SCL1_BASE + 0x77)
#define REG_SCL1_3C_L        (REG_SCL1_BASE + 0x78)
#define REG_SCL1_3C_H        (REG_SCL1_BASE + 0x79)
#define REG_SCL1_3D_L        (REG_SCL1_BASE + 0x7A)
#define REG_SCL1_3D_H        (REG_SCL1_BASE + 0x7B)
#define REG_SCL1_3E_L        (REG_SCL1_BASE + 0x7C)
#define REG_SCL1_3E_H        (REG_SCL1_BASE + 0x7D)
#define REG_SCL1_3F_L        (REG_SCL1_BASE + 0x7E)
#define REG_SCL1_3F_H        (REG_SCL1_BASE + 0x7F)
#define REG_SCL1_40_L        (REG_SCL1_BASE + 0x80)
#define REG_SCL1_40_H        (REG_SCL1_BASE + 0x81)
#define REG_SCL1_41_L        (REG_SCL1_BASE + 0x82)
#define REG_SCL1_41_H        (REG_SCL1_BASE + 0x83)
#define REG_SCL1_42_L        (REG_SCL1_BASE + 0x84)
#define REG_SCL1_42_H        (REG_SCL1_BASE + 0x85)
#define REG_SCL1_43_L        (REG_SCL1_BASE + 0x86)
#define REG_SCL1_43_H        (REG_SCL1_BASE + 0x87)
#define REG_SCL1_44_L        (REG_SCL1_BASE + 0x88)
#define REG_SCL1_44_H        (REG_SCL1_BASE + 0x89)
#define REG_SCL1_45_L        (REG_SCL1_BASE + 0x8A)
#define REG_SCL1_45_H        (REG_SCL1_BASE + 0x8B)
#define REG_SCL1_46_L        (REG_SCL1_BASE + 0x8C)
#define REG_SCL1_46_H        (REG_SCL1_BASE + 0x8D)
#define REG_SCL1_47_L        (REG_SCL1_BASE + 0x8E)
#define REG_SCL1_47_H        (REG_SCL1_BASE + 0x8F)
#define REG_SCL1_48_L        (REG_SCL1_BASE + 0x90)
#define REG_SCL1_48_H        (REG_SCL1_BASE + 0x91)
#define REG_SCL1_49_L        (REG_SCL1_BASE + 0x92)
#define REG_SCL1_49_H        (REG_SCL1_BASE + 0x93)
#define REG_SCL1_4A_L        (REG_SCL1_BASE + 0x94)
#define REG_SCL1_4A_H        (REG_SCL1_BASE + 0x95)
#define REG_SCL1_4B_L        (REG_SCL1_BASE + 0x96)
#define REG_SCL1_4B_H        (REG_SCL1_BASE + 0x97)
#define REG_SCL1_4C_L        (REG_SCL1_BASE + 0x98)
#define REG_SCL1_4C_H        (REG_SCL1_BASE + 0x99)
#define REG_SCL1_4D_L        (REG_SCL1_BASE + 0x9A)
#define REG_SCL1_4D_H        (REG_SCL1_BASE + 0x9B)
#define REG_SCL1_4E_L        (REG_SCL1_BASE + 0x9C)
#define REG_SCL1_4E_H        (REG_SCL1_BASE + 0x9D)
#define REG_SCL1_4F_L        (REG_SCL1_BASE + 0x9E)
#define REG_SCL1_4F_H        (REG_SCL1_BASE + 0x9F)
#define REG_SCL1_50_L        (REG_SCL1_BASE + 0xA0)
#define REG_SCL1_50_H        (REG_SCL1_BASE + 0xA1)
#define REG_SCL1_51_L        (REG_SCL1_BASE + 0xA2)
#define REG_SCL1_51_H        (REG_SCL1_BASE + 0xA3)
#define REG_SCL1_52_L        (REG_SCL1_BASE + 0xA4)
#define REG_SCL1_52_H        (REG_SCL1_BASE + 0xA5)
#define REG_SCL1_53_L        (REG_SCL1_BASE + 0xA6)
#define REG_SCL1_53_H        (REG_SCL1_BASE + 0xA7)
#define REG_SCL1_54_L        (REG_SCL1_BASE + 0xA8)
#define REG_SCL1_54_H        (REG_SCL1_BASE + 0xA9)
#define REG_SCL1_55_L        (REG_SCL1_BASE + 0xAA)
#define REG_SCL1_55_H        (REG_SCL1_BASE + 0xAB)
#define REG_SCL1_56_L        (REG_SCL1_BASE + 0xAC)
#define REG_SCL1_56_H        (REG_SCL1_BASE + 0xAD)
#define REG_SCL1_57_L        (REG_SCL1_BASE + 0xAE)
#define REG_SCL1_57_H        (REG_SCL1_BASE + 0xAF)
#define REG_SCL1_58_L        (REG_SCL1_BASE + 0xB0)
#define REG_SCL1_58_H        (REG_SCL1_BASE + 0xB1)
#define REG_SCL1_59_L        (REG_SCL1_BASE + 0xB2)
#define REG_SCL1_59_H        (REG_SCL1_BASE + 0xB3)
#define REG_SCL1_5A_L        (REG_SCL1_BASE + 0xB4)
#define REG_SCL1_5A_H        (REG_SCL1_BASE + 0xB5)
#define REG_SCL1_5B_L        (REG_SCL1_BASE + 0xB6)
#define REG_SCL1_5B_H        (REG_SCL1_BASE + 0xB7)
#define REG_SCL1_5C_L        (REG_SCL1_BASE + 0xB8)
#define REG_SCL1_5C_H        (REG_SCL1_BASE + 0xB9)
#define REG_SCL1_5D_L        (REG_SCL1_BASE + 0xBA)
#define REG_SCL1_5D_H        (REG_SCL1_BASE + 0xBB)
#define REG_SCL1_5E_L        (REG_SCL1_BASE + 0xBC)
#define REG_SCL1_5E_H        (REG_SCL1_BASE + 0xBD)
#define REG_SCL1_5F_L        (REG_SCL1_BASE + 0xBE)
#define REG_SCL1_5F_H        (REG_SCL1_BASE + 0xBF)
#define REG_SCL1_60_L        (REG_SCL1_BASE + 0xC0)
#define REG_SCL1_60_H        (REG_SCL1_BASE + 0xC1)
#define REG_SCL1_61_L        (REG_SCL1_BASE + 0xC2)
#define REG_SCL1_61_H        (REG_SCL1_BASE + 0xC3)
#define REG_SCL1_62_L        (REG_SCL1_BASE + 0xC4)
#define REG_SCL1_62_H        (REG_SCL1_BASE + 0xC5)
#define REG_SCL1_63_L        (REG_SCL1_BASE + 0xC6)
#define REG_SCL1_63_H        (REG_SCL1_BASE + 0xC7)
#define REG_SCL1_64_L        (REG_SCL1_BASE + 0xC8)
#define REG_SCL1_64_H        (REG_SCL1_BASE + 0xC9)
#define REG_SCL1_65_L        (REG_SCL1_BASE + 0xCA)
#define REG_SCL1_65_H        (REG_SCL1_BASE + 0xCB)
#define REG_SCL1_66_L        (REG_SCL1_BASE + 0xCC)
#define REG_SCL1_66_H        (REG_SCL1_BASE + 0xCD)
#define REG_SCL1_67_L        (REG_SCL1_BASE + 0xCE)
#define REG_SCL1_67_H        (REG_SCL1_BASE + 0xCF)
#define REG_SCL1_68_L        (REG_SCL1_BASE + 0xD0)
#define REG_SCL1_68_H        (REG_SCL1_BASE + 0xD1)
#define REG_SCL1_69_L        (REG_SCL1_BASE + 0xD2)
#define REG_SCL1_69_H        (REG_SCL1_BASE + 0xD3)
#define REG_SCL1_6A_L        (REG_SCL1_BASE + 0xD4)
#define REG_SCL1_6A_H        (REG_SCL1_BASE + 0xD5)
#define REG_SCL1_6B_L        (REG_SCL1_BASE + 0xD6)
#define REG_SCL1_6B_H        (REG_SCL1_BASE + 0xD7)
#define REG_SCL1_6C_L        (REG_SCL1_BASE + 0xD8)
#define REG_SCL1_6C_H        (REG_SCL1_BASE + 0xD9)
#define REG_SCL1_6D_L        (REG_SCL1_BASE + 0xDA)
#define REG_SCL1_6D_H        (REG_SCL1_BASE + 0xDB)
#define REG_SCL1_6E_L        (REG_SCL1_BASE + 0xDC)
#define REG_SCL1_6E_H        (REG_SCL1_BASE + 0xDD)
#define REG_SCL1_6F_L        (REG_SCL1_BASE + 0xDE)
#define REG_SCL1_6F_H        (REG_SCL1_BASE + 0xDF)
#define REG_SCL1_70_L        (REG_SCL1_BASE + 0xE0)
#define REG_SCL1_70_H        (REG_SCL1_BASE + 0xE1)
#define REG_SCL1_71_L        (REG_SCL1_BASE + 0xE2)
#define REG_SCL1_71_H        (REG_SCL1_BASE + 0xE3)
#define REG_SCL1_72_L        (REG_SCL1_BASE + 0xE4)
#define REG_SCL1_72_H        (REG_SCL1_BASE + 0xE5)
#define REG_SCL1_73_L        (REG_SCL1_BASE + 0xE6)
#define REG_SCL1_73_H        (REG_SCL1_BASE + 0xE7)
#define REG_SCL1_74_L        (REG_SCL1_BASE + 0xE8)
#define REG_SCL1_74_H        (REG_SCL1_BASE + 0xE9)
#define REG_SCL1_75_L        (REG_SCL1_BASE + 0xEA)
#define REG_SCL1_75_H        (REG_SCL1_BASE + 0xEB)
#define REG_SCL1_76_L        (REG_SCL1_BASE + 0xEC)
#define REG_SCL1_76_H        (REG_SCL1_BASE + 0xED)
#define REG_SCL1_77_L        (REG_SCL1_BASE + 0xEE)
#define REG_SCL1_77_H        (REG_SCL1_BASE + 0xEF)
#define REG_SCL1_78_L        (REG_SCL1_BASE + 0xF0)
#define REG_SCL1_78_H        (REG_SCL1_BASE + 0xF1)
#define REG_SCL1_79_L        (REG_SCL1_BASE + 0xF2)
#define REG_SCL1_79_H        (REG_SCL1_BASE + 0xF3)
#define REG_SCL1_7A_L        (REG_SCL1_BASE + 0xF4)
#define REG_SCL1_7A_H        (REG_SCL1_BASE + 0xF5)
#define REG_SCL1_7B_L        (REG_SCL1_BASE + 0xF6)
#define REG_SCL1_7B_H        (REG_SCL1_BASE + 0xF7)
#define REG_SCL1_7C_L        (REG_SCL1_BASE + 0xF8)
#define REG_SCL1_7C_H        (REG_SCL1_BASE + 0xF9)
#define REG_SCL1_7D_L        (REG_SCL1_BASE + 0xFA)
#define REG_SCL1_7D_H        (REG_SCL1_BASE + 0xFB)
#define REG_SCL1_7E_L        (REG_SCL1_BASE + 0xFC)
#define REG_SCL1_7E_H        (REG_SCL1_BASE + 0xFD)
#define REG_SCL1_7F_L        (REG_SCL1_BASE + 0xFE)
#define REG_SCL1_7F_H        (REG_SCL1_BASE + 0xFF)

#define REG_SCL2_00_L        (REG_SCL2_BASE + 0x00)
#define REG_SCL2_00_H        (REG_SCL2_BASE + 0x01)
#define REG_SCL2_01_L        (REG_SCL2_BASE + 0x02)
#define REG_SCL2_01_H        (REG_SCL2_BASE + 0x03)
#define REG_SCL2_02_L        (REG_SCL2_BASE + 0x04)
#define REG_SCL2_02_H        (REG_SCL2_BASE + 0x05)
#define REG_SCL2_03_L        (REG_SCL2_BASE + 0x06)
#define REG_SCL2_03_H        (REG_SCL2_BASE + 0x07)
#define REG_SCL2_04_L        (REG_SCL2_BASE + 0x08)
#define REG_SCL2_04_H        (REG_SCL2_BASE + 0x09)
#define REG_SCL2_05_L        (REG_SCL2_BASE + 0x0A)
#define REG_SCL2_05_H        (REG_SCL2_BASE + 0x0B)
#define REG_SCL2_06_L        (REG_SCL2_BASE + 0x0C)
#define REG_SCL2_06_H        (REG_SCL2_BASE + 0x0D)
#define REG_SCL2_07_L        (REG_SCL2_BASE + 0x0E)
#define REG_SCL2_07_H        (REG_SCL2_BASE + 0x0F)
#define REG_SCL2_08_L        (REG_SCL2_BASE + 0x10)
#define REG_SCL2_08_H        (REG_SCL2_BASE + 0x11)
#define REG_SCL2_09_L        (REG_SCL2_BASE + 0x12)
#define REG_SCL2_09_H        (REG_SCL2_BASE + 0x13)
#define REG_SCL2_0A_L        (REG_SCL2_BASE + 0x14)
#define REG_SCL2_0A_H        (REG_SCL2_BASE + 0x15)
#define REG_SCL2_0B_L        (REG_SCL2_BASE + 0x16)
#define REG_SCL2_0B_H        (REG_SCL2_BASE + 0x17)
#define REG_SCL2_0C_L        (REG_SCL2_BASE + 0x18)
#define REG_SCL2_0C_H        (REG_SCL2_BASE + 0x19)
#define REG_SCL2_0D_L        (REG_SCL2_BASE + 0x1A)
#define REG_SCL2_0D_H        (REG_SCL2_BASE + 0x1B)
#define REG_SCL2_0E_L        (REG_SCL2_BASE + 0x1C)
#define REG_SCL2_0E_H        (REG_SCL2_BASE + 0x1D)
#define REG_SCL2_0F_L        (REG_SCL2_BASE + 0x1E)
#define REG_SCL2_0F_H        (REG_SCL2_BASE + 0x1F)
#define REG_SCL2_10_L        (REG_SCL2_BASE + 0x20)
#define REG_SCL2_10_H        (REG_SCL2_BASE + 0x21)
#define REG_SCL2_11_L        (REG_SCL2_BASE + 0x22)
#define REG_SCL2_11_H        (REG_SCL2_BASE + 0x23)
#define REG_SCL2_12_L        (REG_SCL2_BASE + 0x24)
#define REG_SCL2_12_H        (REG_SCL2_BASE + 0x25)
#define REG_SCL2_13_L        (REG_SCL2_BASE + 0x26)
#define REG_SCL2_13_H        (REG_SCL2_BASE + 0x27)
#define REG_SCL2_14_L        (REG_SCL2_BASE + 0x28)
#define REG_SCL2_14_H        (REG_SCL2_BASE + 0x29)
#define REG_SCL2_15_L        (REG_SCL2_BASE + 0x2A)
#define REG_SCL2_15_H        (REG_SCL2_BASE + 0x2B)
#define REG_SCL2_16_L        (REG_SCL2_BASE + 0x2C)
#define REG_SCL2_16_H        (REG_SCL2_BASE + 0x2D)
#define REG_SCL2_17_L        (REG_SCL2_BASE + 0x2E)
#define REG_SCL2_17_H        (REG_SCL2_BASE + 0x2F)
#define REG_SCL2_18_L        (REG_SCL2_BASE + 0x30)
#define REG_SCL2_18_H        (REG_SCL2_BASE + 0x31)
#define REG_SCL2_19_L        (REG_SCL2_BASE + 0x32)
#define REG_SCL2_19_H        (REG_SCL2_BASE + 0x33)
#define REG_SCL2_1A_L        (REG_SCL2_BASE + 0x34)
#define REG_SCL2_1A_H        (REG_SCL2_BASE + 0x35)
#define REG_SCL2_1B_L        (REG_SCL2_BASE + 0x36)
#define REG_SCL2_1B_H        (REG_SCL2_BASE + 0x37)
#define REG_SCL2_1C_L        (REG_SCL2_BASE + 0x38)
#define REG_SCL2_1C_H        (REG_SCL2_BASE + 0x39)
#define REG_SCL2_1D_L        (REG_SCL2_BASE + 0x3A)
#define REG_SCL2_1D_H        (REG_SCL2_BASE + 0x3B)
#define REG_SCL2_1E_L        (REG_SCL2_BASE + 0x3C)
#define REG_SCL2_1E_H        (REG_SCL2_BASE + 0x3D)
#define REG_SCL2_1F_L        (REG_SCL2_BASE + 0x3E)
#define REG_SCL2_1F_H        (REG_SCL2_BASE + 0x3F)
#define REG_SCL2_20_L        (REG_SCL2_BASE + 0x40)
#define REG_SCL2_20_H        (REG_SCL2_BASE + 0x41)
#define REG_SCL2_21_L        (REG_SCL2_BASE + 0x42)
#define REG_SCL2_21_H        (REG_SCL2_BASE + 0x43)
#define REG_SCL2_22_L        (REG_SCL2_BASE + 0x44)
#define REG_SCL2_22_H        (REG_SCL2_BASE + 0x45)
#define REG_SCL2_23_L        (REG_SCL2_BASE + 0x46)
#define REG_SCL2_23_H        (REG_SCL2_BASE + 0x47)
#define REG_SCL2_24_L        (REG_SCL2_BASE + 0x48)
#define REG_SCL2_24_H        (REG_SCL2_BASE + 0x49)
#define REG_SCL2_25_L        (REG_SCL2_BASE + 0x4A)
#define REG_SCL2_25_H        (REG_SCL2_BASE + 0x4B)
#define REG_SCL2_26_L        (REG_SCL2_BASE + 0x4C)
#define REG_SCL2_26_H        (REG_SCL2_BASE + 0x4D)
#define REG_SCL2_27_L        (REG_SCL2_BASE + 0x4E)
#define REG_SCL2_27_H        (REG_SCL2_BASE + 0x4F)
#define REG_SCL2_28_L        (REG_SCL2_BASE + 0x50)
#define REG_SCL2_28_H        (REG_SCL2_BASE + 0x51)
#define REG_SCL2_29_L        (REG_SCL2_BASE + 0x52)
#define REG_SCL2_29_H        (REG_SCL2_BASE + 0x53)
#define REG_SCL2_2A_L        (REG_SCL2_BASE + 0x54)
#define REG_SCL2_2A_H        (REG_SCL2_BASE + 0x55)
#define REG_SCL2_2B_L        (REG_SCL2_BASE + 0x56)
#define REG_SCL2_2B_H        (REG_SCL2_BASE + 0x57)
#define REG_SCL2_2C_L        (REG_SCL2_BASE + 0x58)
#define REG_SCL2_2C_H        (REG_SCL2_BASE + 0x59)
#define REG_SCL2_2D_L        (REG_SCL2_BASE + 0x5A)
#define REG_SCL2_2D_H        (REG_SCL2_BASE + 0x5B)
#define REG_SCL2_2E_L        (REG_SCL2_BASE + 0x5C)
#define REG_SCL2_2E_H        (REG_SCL2_BASE + 0x5D)
#define REG_SCL2_2F_L        (REG_SCL2_BASE + 0x5E)
#define REG_SCL2_2F_H        (REG_SCL2_BASE + 0x5F)
#define REG_SCL2_30_L        (REG_SCL2_BASE + 0x60)
#define REG_SCL2_30_H        (REG_SCL2_BASE + 0x61)
#define REG_SCL2_31_L        (REG_SCL2_BASE + 0x62)
#define REG_SCL2_31_H        (REG_SCL2_BASE + 0x63)
#define REG_SCL2_32_L        (REG_SCL2_BASE + 0x64)
#define REG_SCL2_32_H        (REG_SCL2_BASE + 0x65)
#define REG_SCL2_33_L        (REG_SCL2_BASE + 0x66)
#define REG_SCL2_33_H        (REG_SCL2_BASE + 0x67)
#define REG_SCL2_34_L        (REG_SCL2_BASE + 0x68)
#define REG_SCL2_34_H        (REG_SCL2_BASE + 0x69)
#define REG_SCL2_35_L        (REG_SCL2_BASE + 0x6A)
#define REG_SCL2_35_H        (REG_SCL2_BASE + 0x6B)
#define REG_SCL2_36_L        (REG_SCL2_BASE + 0x6C)
#define REG_SCL2_36_H        (REG_SCL2_BASE + 0x6D)
#define REG_SCL2_37_L        (REG_SCL2_BASE + 0x6E)
#define REG_SCL2_37_H        (REG_SCL2_BASE + 0x6F)
#define REG_SCL2_38_L        (REG_SCL2_BASE + 0x70)
#define REG_SCL2_38_H        (REG_SCL2_BASE + 0x71)
#define REG_SCL2_39_L        (REG_SCL2_BASE + 0x72)
#define REG_SCL2_39_H        (REG_SCL2_BASE + 0x73)
#define REG_SCL2_3A_L        (REG_SCL2_BASE + 0x74)
#define REG_SCL2_3A_H        (REG_SCL2_BASE + 0x75)
#define REG_SCL2_3B_L        (REG_SCL2_BASE + 0x76)
#define REG_SCL2_3B_H        (REG_SCL2_BASE + 0x77)
#define REG_SCL2_3C_L        (REG_SCL2_BASE + 0x78)
#define REG_SCL2_3C_H        (REG_SCL2_BASE + 0x79)
#define REG_SCL2_3D_L        (REG_SCL2_BASE + 0x7A)
#define REG_SCL2_3D_H        (REG_SCL2_BASE + 0x7B)
#define REG_SCL2_3E_L        (REG_SCL2_BASE + 0x7C)
#define REG_SCL2_3E_H        (REG_SCL2_BASE + 0x7D)
#define REG_SCL2_3F_L        (REG_SCL2_BASE + 0x7E)
#define REG_SCL2_3F_H        (REG_SCL2_BASE + 0x7F)
#define REG_SCL2_40_L        (REG_SCL2_BASE + 0x80)
#define REG_SCL2_40_H        (REG_SCL2_BASE + 0x81)
#define REG_SCL2_41_L        (REG_SCL2_BASE + 0x82)
#define REG_SCL2_41_H        (REG_SCL2_BASE + 0x83)
#define REG_SCL2_42_L        (REG_SCL2_BASE + 0x84)
#define REG_SCL2_42_H        (REG_SCL2_BASE + 0x85)
#define REG_SCL2_43_L        (REG_SCL2_BASE + 0x86)
#define REG_SCL2_43_H        (REG_SCL2_BASE + 0x87)
#define REG_SCL2_44_L        (REG_SCL2_BASE + 0x88)
#define REG_SCL2_44_H        (REG_SCL2_BASE + 0x89)
#define REG_SCL2_45_L        (REG_SCL2_BASE + 0x8A)
#define REG_SCL2_45_H        (REG_SCL2_BASE + 0x8B)
#define REG_SCL2_46_L        (REG_SCL2_BASE + 0x8C)
#define REG_SCL2_46_H        (REG_SCL2_BASE + 0x8D)
#define REG_SCL2_47_L        (REG_SCL2_BASE + 0x8E)
#define REG_SCL2_47_H        (REG_SCL2_BASE + 0x8F)
#define REG_SCL2_48_L        (REG_SCL2_BASE + 0x90)
#define REG_SCL2_48_H        (REG_SCL2_BASE + 0x91)
#define REG_SCL2_49_L        (REG_SCL2_BASE + 0x92)
#define REG_SCL2_49_H        (REG_SCL2_BASE + 0x93)
#define REG_SCL2_4A_L        (REG_SCL2_BASE + 0x94)
#define REG_SCL2_4A_H        (REG_SCL2_BASE + 0x95)
#define REG_SCL2_4B_L        (REG_SCL2_BASE + 0x96)
#define REG_SCL2_4B_H        (REG_SCL2_BASE + 0x97)
#define REG_SCL2_4C_L        (REG_SCL2_BASE + 0x98)
#define REG_SCL2_4C_H        (REG_SCL2_BASE + 0x99)
#define REG_SCL2_4D_L        (REG_SCL2_BASE + 0x9A)
#define REG_SCL2_4D_H        (REG_SCL2_BASE + 0x9B)
#define REG_SCL2_4E_L        (REG_SCL2_BASE + 0x9C)
#define REG_SCL2_4E_H        (REG_SCL2_BASE + 0x9D)
#define REG_SCL2_4F_L        (REG_SCL2_BASE + 0x9E)
#define REG_SCL2_4F_H        (REG_SCL2_BASE + 0x9F)
#define REG_SCL2_50_L        (REG_SCL2_BASE + 0xA0)
#define REG_SCL2_50_H        (REG_SCL2_BASE + 0xA1)
#define REG_SCL2_51_L        (REG_SCL2_BASE + 0xA2)
#define REG_SCL2_51_H        (REG_SCL2_BASE + 0xA3)
#define REG_SCL2_52_L        (REG_SCL2_BASE + 0xA4)
#define REG_SCL2_52_H        (REG_SCL2_BASE + 0xA5)
#define REG_SCL2_53_L        (REG_SCL2_BASE + 0xA6)
#define REG_SCL2_53_H        (REG_SCL2_BASE + 0xA7)
#define REG_SCL2_54_L        (REG_SCL2_BASE + 0xA8)
#define REG_SCL2_54_H        (REG_SCL2_BASE + 0xA9)
#define REG_SCL2_55_L        (REG_SCL2_BASE + 0xAA)
#define REG_SCL2_55_H        (REG_SCL2_BASE + 0xAB)
#define REG_SCL2_56_L        (REG_SCL2_BASE + 0xAC)
#define REG_SCL2_56_H        (REG_SCL2_BASE + 0xAD)
#define REG_SCL2_57_L        (REG_SCL2_BASE + 0xAE)
#define REG_SCL2_57_H        (REG_SCL2_BASE + 0xAF)
#define REG_SCL2_58_L        (REG_SCL2_BASE + 0xB0)
#define REG_SCL2_58_H        (REG_SCL2_BASE + 0xB1)
#define REG_SCL2_59_L        (REG_SCL2_BASE + 0xB2)
#define REG_SCL2_59_H        (REG_SCL2_BASE + 0xB3)
#define REG_SCL2_5A_L        (REG_SCL2_BASE + 0xB4)
#define REG_SCL2_5A_H        (REG_SCL2_BASE + 0xB5)
#define REG_SCL2_5B_L        (REG_SCL2_BASE + 0xB6)
#define REG_SCL2_5B_H        (REG_SCL2_BASE + 0xB7)
#define REG_SCL2_5C_L        (REG_SCL2_BASE + 0xB8)
#define REG_SCL2_5C_H        (REG_SCL2_BASE + 0xB9)
#define REG_SCL2_5D_L        (REG_SCL2_BASE + 0xBA)
#define REG_SCL2_5D_H        (REG_SCL2_BASE + 0xBB)
#define REG_SCL2_5E_L        (REG_SCL2_BASE + 0xBC)
#define REG_SCL2_5E_H        (REG_SCL2_BASE + 0xBD)
#define REG_SCL2_5F_L        (REG_SCL2_BASE + 0xBE)
#define REG_SCL2_5F_H        (REG_SCL2_BASE + 0xBF)
#define REG_SCL2_60_L        (REG_SCL2_BASE + 0xC0)
#define REG_SCL2_60_H        (REG_SCL2_BASE + 0xC1)
#define REG_SCL2_61_L        (REG_SCL2_BASE + 0xC2)
#define REG_SCL2_61_H        (REG_SCL2_BASE + 0xC3)
#define REG_SCL2_62_L        (REG_SCL2_BASE + 0xC4)
#define REG_SCL2_62_H        (REG_SCL2_BASE + 0xC5)
#define REG_SCL2_63_L        (REG_SCL2_BASE + 0xC6)
#define REG_SCL2_63_H        (REG_SCL2_BASE + 0xC7)
#define REG_SCL2_64_L        (REG_SCL2_BASE + 0xC8)
#define REG_SCL2_64_H        (REG_SCL2_BASE + 0xC9)
#define REG_SCL2_65_L        (REG_SCL2_BASE + 0xCA)
#define REG_SCL2_65_H        (REG_SCL2_BASE + 0xCB)
#define REG_SCL2_66_L        (REG_SCL2_BASE + 0xCC)
#define REG_SCL2_66_H        (REG_SCL2_BASE + 0xCD)
#define REG_SCL2_67_L        (REG_SCL2_BASE + 0xCE)
#define REG_SCL2_67_H        (REG_SCL2_BASE + 0xCF)
#define REG_SCL2_68_L        (REG_SCL2_BASE + 0xD0)
#define REG_SCL2_68_H        (REG_SCL2_BASE + 0xD1)
#define REG_SCL2_69_L        (REG_SCL2_BASE + 0xD2)
#define REG_SCL2_69_H        (REG_SCL2_BASE + 0xD3)
#define REG_SCL2_6A_L        (REG_SCL2_BASE + 0xD4)
#define REG_SCL2_6A_H        (REG_SCL2_BASE + 0xD5)
#define REG_SCL2_6B_L        (REG_SCL2_BASE + 0xD6)
#define REG_SCL2_6B_H        (REG_SCL2_BASE + 0xD7)
#define REG_SCL2_6C_L        (REG_SCL2_BASE + 0xD8)
#define REG_SCL2_6C_H        (REG_SCL2_BASE + 0xD9)
#define REG_SCL2_6D_L        (REG_SCL2_BASE + 0xDA)
#define REG_SCL2_6D_H        (REG_SCL2_BASE + 0xDB)
#define REG_SCL2_6E_L        (REG_SCL2_BASE + 0xDC)
#define REG_SCL2_6E_H        (REG_SCL2_BASE + 0xDD)
#define REG_SCL2_6F_L        (REG_SCL2_BASE + 0xDE)
#define REG_SCL2_6F_H        (REG_SCL2_BASE + 0xDF)
#define REG_SCL2_70_L        (REG_SCL2_BASE + 0xE0)
#define REG_SCL2_70_H        (REG_SCL2_BASE + 0xE1)
#define REG_SCL2_71_L        (REG_SCL2_BASE + 0xE2)
#define REG_SCL2_71_H        (REG_SCL2_BASE + 0xE3)
#define REG_SCL2_72_L        (REG_SCL2_BASE + 0xE4)
#define REG_SCL2_72_H        (REG_SCL2_BASE + 0xE5)
#define REG_SCL2_73_L        (REG_SCL2_BASE + 0xE6)
#define REG_SCL2_73_H        (REG_SCL2_BASE + 0xE7)
#define REG_SCL2_74_L        (REG_SCL2_BASE + 0xE8)
#define REG_SCL2_74_H        (REG_SCL2_BASE + 0xE9)
#define REG_SCL2_75_L        (REG_SCL2_BASE + 0xEA)
#define REG_SCL2_75_H        (REG_SCL2_BASE + 0xEB)
#define REG_SCL2_76_L        (REG_SCL2_BASE + 0xEC)
#define REG_SCL2_76_H        (REG_SCL2_BASE + 0xED)
#define REG_SCL2_77_L        (REG_SCL2_BASE + 0xEE)
#define REG_SCL2_77_H        (REG_SCL2_BASE + 0xEF)
#define REG_SCL2_78_L        (REG_SCL2_BASE + 0xF0)
#define REG_SCL2_78_H        (REG_SCL2_BASE + 0xF1)
#define REG_SCL2_79_L        (REG_SCL2_BASE + 0xF2)
#define REG_SCL2_79_H        (REG_SCL2_BASE + 0xF3)
#define REG_SCL2_7A_L        (REG_SCL2_BASE + 0xF4)
#define REG_SCL2_7A_H        (REG_SCL2_BASE + 0xF5)
#define REG_SCL2_7B_L        (REG_SCL2_BASE + 0xF6)
#define REG_SCL2_7B_H        (REG_SCL2_BASE + 0xF7)
#define REG_SCL2_7C_L        (REG_SCL2_BASE + 0xF8)
#define REG_SCL2_7C_H        (REG_SCL2_BASE + 0xF9)
#define REG_SCL2_7D_L        (REG_SCL2_BASE + 0xFA)
#define REG_SCL2_7D_H        (REG_SCL2_BASE + 0xFB)
#define REG_SCL2_7E_L        (REG_SCL2_BASE + 0xFC)
#define REG_SCL2_7E_H        (REG_SCL2_BASE + 0xFD)
#define REG_SCL2_7F_L        (REG_SCL2_BASE + 0xFE)
#define REG_SCL2_7F_H        (REG_SCL2_BASE + 0xFF)

#define REG_SCL3_00_L        (REG_SCL3_BASE + 0x00)
#define REG_SCL3_00_H        (REG_SCL3_BASE + 0x01)
#define REG_SCL3_01_L        (REG_SCL3_BASE + 0x02)
#define REG_SCL3_01_H        (REG_SCL3_BASE + 0x03)
#define REG_SCL3_02_L        (REG_SCL3_BASE + 0x04)
#define REG_SCL3_02_H        (REG_SCL3_BASE + 0x05)
#define REG_SCL3_03_L        (REG_SCL3_BASE + 0x06)
#define REG_SCL3_03_H        (REG_SCL3_BASE + 0x07)
#define REG_SCL3_04_L        (REG_SCL3_BASE + 0x08)
#define REG_SCL3_04_H        (REG_SCL3_BASE + 0x09)
#define REG_SCL3_05_L        (REG_SCL3_BASE + 0x0A)
#define REG_SCL3_05_H        (REG_SCL3_BASE + 0x0B)
#define REG_SCL3_06_L        (REG_SCL3_BASE + 0x0C)
#define REG_SCL3_06_H        (REG_SCL3_BASE + 0x0D)
#define REG_SCL3_07_L        (REG_SCL3_BASE + 0x0E)
#define REG_SCL3_07_H        (REG_SCL3_BASE + 0x0F)
#define REG_SCL3_08_L        (REG_SCL3_BASE + 0x10)
#define REG_SCL3_08_H        (REG_SCL3_BASE + 0x11)
#define REG_SCL3_09_L        (REG_SCL3_BASE + 0x12)
#define REG_SCL3_09_H        (REG_SCL3_BASE + 0x13)
#define REG_SCL3_0A_L        (REG_SCL3_BASE + 0x14)
#define REG_SCL3_0A_H        (REG_SCL3_BASE + 0x15)
#define REG_SCL3_0B_L        (REG_SCL3_BASE + 0x16)
#define REG_SCL3_0B_H        (REG_SCL3_BASE + 0x17)
#define REG_SCL3_0C_L        (REG_SCL3_BASE + 0x18)
#define REG_SCL3_0C_H        (REG_SCL3_BASE + 0x19)
#define REG_SCL3_0D_L        (REG_SCL3_BASE + 0x1A)
#define REG_SCL3_0D_H        (REG_SCL3_BASE + 0x1B)
#define REG_SCL3_0E_L        (REG_SCL3_BASE + 0x1C)
#define REG_SCL3_0E_H        (REG_SCL3_BASE + 0x1D)
#define REG_SCL3_0F_L        (REG_SCL3_BASE + 0x1E)
#define REG_SCL3_0F_H        (REG_SCL3_BASE + 0x1F)
#define REG_SCL3_10_L        (REG_SCL3_BASE + 0x20)
#define REG_SCL3_10_H        (REG_SCL3_BASE + 0x21)
#define REG_SCL3_11_L        (REG_SCL3_BASE + 0x22)
#define REG_SCL3_11_H        (REG_SCL3_BASE + 0x23)
#define REG_SCL3_12_L        (REG_SCL3_BASE + 0x24)
#define REG_SCL3_12_H        (REG_SCL3_BASE + 0x25)
#define REG_SCL3_13_L        (REG_SCL3_BASE + 0x26)
#define REG_SCL3_13_H        (REG_SCL3_BASE + 0x27)
#define REG_SCL3_14_L        (REG_SCL3_BASE + 0x28)
#define REG_SCL3_14_H        (REG_SCL3_BASE + 0x29)
#define REG_SCL3_15_L        (REG_SCL3_BASE + 0x2A)
#define REG_SCL3_15_H        (REG_SCL3_BASE + 0x2B)
#define REG_SCL3_16_L        (REG_SCL3_BASE + 0x2C)
#define REG_SCL3_16_H        (REG_SCL3_BASE + 0x2D)
#define REG_SCL3_17_L        (REG_SCL3_BASE + 0x2E)
#define REG_SCL3_17_H        (REG_SCL3_BASE + 0x2F)
#define REG_SCL3_18_L        (REG_SCL3_BASE + 0x30)
#define REG_SCL3_18_H        (REG_SCL3_BASE + 0x31)
#define REG_SCL3_19_L        (REG_SCL3_BASE + 0x32)
#define REG_SCL3_19_H        (REG_SCL3_BASE + 0x33)
#define REG_SCL3_1A_L        (REG_SCL3_BASE + 0x34)
#define REG_SCL3_1A_H        (REG_SCL3_BASE + 0x35)
#define REG_SCL3_1B_L        (REG_SCL3_BASE + 0x36)
#define REG_SCL3_1B_H        (REG_SCL3_BASE + 0x37)
#define REG_SCL3_1C_L        (REG_SCL3_BASE + 0x38)
#define REG_SCL3_1C_H        (REG_SCL3_BASE + 0x39)
#define REG_SCL3_1D_L        (REG_SCL3_BASE + 0x3A)
#define REG_SCL3_1D_H        (REG_SCL3_BASE + 0x3B)
#define REG_SCL3_1E_L        (REG_SCL3_BASE + 0x3C)
#define REG_SCL3_1E_H        (REG_SCL3_BASE + 0x3D)
#define REG_SCL3_1F_L        (REG_SCL3_BASE + 0x3E)
#define REG_SCL3_1F_H        (REG_SCL3_BASE + 0x3F)
#define REG_SCL3_20_L        (REG_SCL3_BASE + 0x40)
#define REG_SCL3_20_H        (REG_SCL3_BASE + 0x41)
#define REG_SCL3_21_L        (REG_SCL3_BASE + 0x42)
#define REG_SCL3_21_H        (REG_SCL3_BASE + 0x43)
#define REG_SCL3_22_L        (REG_SCL3_BASE + 0x44)
#define REG_SCL3_22_H        (REG_SCL3_BASE + 0x45)
#define REG_SCL3_23_L        (REG_SCL3_BASE + 0x46)
#define REG_SCL3_23_H        (REG_SCL3_BASE + 0x47)
#define REG_SCL3_24_L        (REG_SCL3_BASE + 0x48)
#define REG_SCL3_24_H        (REG_SCL3_BASE + 0x49)
#define REG_SCL3_25_L        (REG_SCL3_BASE + 0x4A)
#define REG_SCL3_25_H        (REG_SCL3_BASE + 0x4B)
#define REG_SCL3_26_L        (REG_SCL3_BASE + 0x4C)
#define REG_SCL3_26_H        (REG_SCL3_BASE + 0x4D)
#define REG_SCL3_27_L        (REG_SCL3_BASE + 0x4E)
#define REG_SCL3_27_H        (REG_SCL3_BASE + 0x4F)
#define REG_SCL3_28_L        (REG_SCL3_BASE + 0x50)
#define REG_SCL3_28_H        (REG_SCL3_BASE + 0x51)
#define REG_SCL3_29_L        (REG_SCL3_BASE + 0x52)
#define REG_SCL3_29_H        (REG_SCL3_BASE + 0x53)
#define REG_SCL3_2A_L        (REG_SCL3_BASE + 0x54)
#define REG_SCL3_2A_H        (REG_SCL3_BASE + 0x55)
#define REG_SCL3_2B_L        (REG_SCL3_BASE + 0x56)
#define REG_SCL3_2B_H        (REG_SCL3_BASE + 0x57)
#define REG_SCL3_2C_L        (REG_SCL3_BASE + 0x58)
#define REG_SCL3_2C_H        (REG_SCL3_BASE + 0x59)
#define REG_SCL3_2D_L        (REG_SCL3_BASE + 0x5A)
#define REG_SCL3_2D_H        (REG_SCL3_BASE + 0x5B)
#define REG_SCL3_2E_L        (REG_SCL3_BASE + 0x5C)
#define REG_SCL3_2E_H        (REG_SCL3_BASE + 0x5D)
#define REG_SCL3_2F_L        (REG_SCL3_BASE + 0x5E)
#define REG_SCL3_2F_H        (REG_SCL3_BASE + 0x5F)
#define REG_SCL3_30_L        (REG_SCL3_BASE + 0x60)
#define REG_SCL3_30_H        (REG_SCL3_BASE + 0x61)
#define REG_SCL3_31_L        (REG_SCL3_BASE + 0x62)
#define REG_SCL3_31_H        (REG_SCL3_BASE + 0x63)
#define REG_SCL3_32_L        (REG_SCL3_BASE + 0x64)
#define REG_SCL3_32_H        (REG_SCL3_BASE + 0x65)
#define REG_SCL3_33_L        (REG_SCL3_BASE + 0x66)
#define REG_SCL3_33_H        (REG_SCL3_BASE + 0x67)
#define REG_SCL3_34_L        (REG_SCL3_BASE + 0x68)
#define REG_SCL3_34_H        (REG_SCL3_BASE + 0x69)
#define REG_SCL3_35_L        (REG_SCL3_BASE + 0x6A)
#define REG_SCL3_35_H        (REG_SCL3_BASE + 0x6B)
#define REG_SCL3_36_L        (REG_SCL3_BASE + 0x6C)
#define REG_SCL3_36_H        (REG_SCL3_BASE + 0x6D)
#define REG_SCL3_37_L        (REG_SCL3_BASE + 0x6E)
#define REG_SCL3_37_H        (REG_SCL3_BASE + 0x6F)
#define REG_SCL3_38_L        (REG_SCL3_BASE + 0x70)
#define REG_SCL3_38_H        (REG_SCL3_BASE + 0x71)
#define REG_SCL3_39_L        (REG_SCL3_BASE + 0x72)
#define REG_SCL3_39_H        (REG_SCL3_BASE + 0x73)
#define REG_SCL3_3A_L        (REG_SCL3_BASE + 0x74)
#define REG_SCL3_3A_H        (REG_SCL3_BASE + 0x75)
#define REG_SCL3_3B_L        (REG_SCL3_BASE + 0x76)
#define REG_SCL3_3B_H        (REG_SCL3_BASE + 0x77)
#define REG_SCL3_3C_L        (REG_SCL3_BASE + 0x78)
#define REG_SCL3_3C_H        (REG_SCL3_BASE + 0x79)
#define REG_SCL3_3D_L        (REG_SCL3_BASE + 0x7A)
#define REG_SCL3_3D_H        (REG_SCL3_BASE + 0x7B)
#define REG_SCL3_3E_L        (REG_SCL3_BASE + 0x7C)
#define REG_SCL3_3E_H        (REG_SCL3_BASE + 0x7D)
#define REG_SCL3_3F_L        (REG_SCL3_BASE + 0x7E)
#define REG_SCL3_3F_H        (REG_SCL3_BASE + 0x7F)
#define REG_SCL3_40_L        (REG_SCL3_BASE + 0x80)
#define REG_SCL3_40_H        (REG_SCL3_BASE + 0x81)
#define REG_SCL3_41_L        (REG_SCL3_BASE + 0x82)
#define REG_SCL3_41_H        (REG_SCL3_BASE + 0x83)
#define REG_SCL3_42_L        (REG_SCL3_BASE + 0x84)
#define REG_SCL3_42_H        (REG_SCL3_BASE + 0x85)
#define REG_SCL3_43_L        (REG_SCL3_BASE + 0x86)
#define REG_SCL3_43_H        (REG_SCL3_BASE + 0x87)
#define REG_SCL3_44_L        (REG_SCL3_BASE + 0x88)
#define REG_SCL3_44_H        (REG_SCL3_BASE + 0x89)
#define REG_SCL3_45_L        (REG_SCL3_BASE + 0x8A)
#define REG_SCL3_45_H        (REG_SCL3_BASE + 0x8B)
#define REG_SCL3_46_L        (REG_SCL3_BASE + 0x8C)
#define REG_SCL3_46_H        (REG_SCL3_BASE + 0x8D)
#define REG_SCL3_47_L        (REG_SCL3_BASE + 0x8E)
#define REG_SCL3_47_H        (REG_SCL3_BASE + 0x8F)
#define REG_SCL3_48_L        (REG_SCL3_BASE + 0x90)
#define REG_SCL3_48_H        (REG_SCL3_BASE + 0x91)
#define REG_SCL3_49_L        (REG_SCL3_BASE + 0x92)
#define REG_SCL3_49_H        (REG_SCL3_BASE + 0x93)
#define REG_SCL3_4A_L        (REG_SCL3_BASE + 0x94)
#define REG_SCL3_4A_H        (REG_SCL3_BASE + 0x95)
#define REG_SCL3_4B_L        (REG_SCL3_BASE + 0x96)
#define REG_SCL3_4B_H        (REG_SCL3_BASE + 0x97)
#define REG_SCL3_4C_L        (REG_SCL3_BASE + 0x98)
#define REG_SCL3_4C_H        (REG_SCL3_BASE + 0x99)
#define REG_SCL3_4D_L        (REG_SCL3_BASE + 0x9A)
#define REG_SCL3_4D_H        (REG_SCL3_BASE + 0x9B)
#define REG_SCL3_4E_L        (REG_SCL3_BASE + 0x9C)
#define REG_SCL3_4E_H        (REG_SCL3_BASE + 0x9D)
#define REG_SCL3_4F_L        (REG_SCL3_BASE + 0x9E)
#define REG_SCL3_4F_H        (REG_SCL3_BASE + 0x9F)
#define REG_SCL3_50_L        (REG_SCL3_BASE + 0xA0)
#define REG_SCL3_50_H        (REG_SCL3_BASE + 0xA1)
#define REG_SCL3_51_L        (REG_SCL3_BASE + 0xA2)
#define REG_SCL3_51_H        (REG_SCL3_BASE + 0xA3)
#define REG_SCL3_52_L        (REG_SCL3_BASE + 0xA4)
#define REG_SCL3_52_H        (REG_SCL3_BASE + 0xA5)
#define REG_SCL3_53_L        (REG_SCL3_BASE + 0xA6)
#define REG_SCL3_53_H        (REG_SCL3_BASE + 0xA7)
#define REG_SCL3_54_L        (REG_SCL3_BASE + 0xA8)
#define REG_SCL3_54_H        (REG_SCL3_BASE + 0xA9)
#define REG_SCL3_55_L        (REG_SCL3_BASE + 0xAA)
#define REG_SCL3_55_H        (REG_SCL3_BASE + 0xAB)
#define REG_SCL3_56_L        (REG_SCL3_BASE + 0xAC)
#define REG_SCL3_56_H        (REG_SCL3_BASE + 0xAD)
#define REG_SCL3_57_L        (REG_SCL3_BASE + 0xAE)
#define REG_SCL3_57_H        (REG_SCL3_BASE + 0xAF)
#define REG_SCL3_58_L        (REG_SCL3_BASE + 0xB0)
#define REG_SCL3_58_H        (REG_SCL3_BASE + 0xB1)
#define REG_SCL3_59_L        (REG_SCL3_BASE + 0xB2)
#define REG_SCL3_59_H        (REG_SCL3_BASE + 0xB3)
#define REG_SCL3_5A_L        (REG_SCL3_BASE + 0xB4)
#define REG_SCL3_5A_H        (REG_SCL3_BASE + 0xB5)
#define REG_SCL3_5B_L        (REG_SCL3_BASE + 0xB6)
#define REG_SCL3_5B_H        (REG_SCL3_BASE + 0xB7)
#define REG_SCL3_5C_L        (REG_SCL3_BASE + 0xB8)
#define REG_SCL3_5C_H        (REG_SCL3_BASE + 0xB9)
#define REG_SCL3_5D_L        (REG_SCL3_BASE + 0xBA)
#define REG_SCL3_5D_H        (REG_SCL3_BASE + 0xBB)
#define REG_SCL3_5E_L        (REG_SCL3_BASE + 0xBC)
#define REG_SCL3_5E_H        (REG_SCL3_BASE + 0xBD)
#define REG_SCL3_5F_L        (REG_SCL3_BASE + 0xBE)
#define REG_SCL3_5F_H        (REG_SCL3_BASE + 0xBF)
#define REG_SCL3_60_L        (REG_SCL3_BASE + 0xC0)
#define REG_SCL3_60_H        (REG_SCL3_BASE + 0xC1)
#define REG_SCL3_61_L        (REG_SCL3_BASE + 0xC2)
#define REG_SCL3_61_H        (REG_SCL3_BASE + 0xC3)
#define REG_SCL3_62_L        (REG_SCL3_BASE + 0xC4)
#define REG_SCL3_62_H        (REG_SCL3_BASE + 0xC5)
#define REG_SCL3_63_L        (REG_SCL3_BASE + 0xC6)
#define REG_SCL3_63_H        (REG_SCL3_BASE + 0xC7)
#define REG_SCL3_64_L        (REG_SCL3_BASE + 0xC8)
#define REG_SCL3_64_H        (REG_SCL3_BASE + 0xC9)
#define REG_SCL3_65_L        (REG_SCL3_BASE + 0xCA)
#define REG_SCL3_65_H        (REG_SCL3_BASE + 0xCB)
#define REG_SCL3_66_L        (REG_SCL3_BASE + 0xCC)
#define REG_SCL3_66_H        (REG_SCL3_BASE + 0xCD)
#define REG_SCL3_67_L        (REG_SCL3_BASE + 0xCE)
#define REG_SCL3_67_H        (REG_SCL3_BASE + 0xCF)
#define REG_SCL3_68_L        (REG_SCL3_BASE + 0xD0)
#define REG_SCL3_68_H        (REG_SCL3_BASE + 0xD1)
#define REG_SCL3_69_L        (REG_SCL3_BASE + 0xD2)
#define REG_SCL3_69_H        (REG_SCL3_BASE + 0xD3)
#define REG_SCL3_6A_L        (REG_SCL3_BASE + 0xD4)
#define REG_SCL3_6A_H        (REG_SCL3_BASE + 0xD5)
#define REG_SCL3_6B_L        (REG_SCL3_BASE + 0xD6)
#define REG_SCL3_6B_H        (REG_SCL3_BASE + 0xD7)
#define REG_SCL3_6C_L        (REG_SCL3_BASE + 0xD8)
#define REG_SCL3_6C_H        (REG_SCL3_BASE + 0xD9)
#define REG_SCL3_6D_L        (REG_SCL3_BASE + 0xDA)
#define REG_SCL3_6D_H        (REG_SCL3_BASE + 0xDB)
#define REG_SCL3_6E_L        (REG_SCL3_BASE + 0xDC)
#define REG_SCL3_6E_H        (REG_SCL3_BASE + 0xDD)
#define REG_SCL3_6F_L        (REG_SCL3_BASE + 0xDE)
#define REG_SCL3_6F_H        (REG_SCL3_BASE + 0xDF)
#define REG_SCL3_70_L        (REG_SCL3_BASE + 0xE0)
#define REG_SCL3_70_H        (REG_SCL3_BASE + 0xE1)
#define REG_SCL3_71_L        (REG_SCL3_BASE + 0xE2)
#define REG_SCL3_71_H        (REG_SCL3_BASE + 0xE3)
#define REG_SCL3_72_L        (REG_SCL3_BASE + 0xE4)
#define REG_SCL3_72_H        (REG_SCL3_BASE + 0xE5)
#define REG_SCL3_73_L        (REG_SCL3_BASE + 0xE6)
#define REG_SCL3_73_H        (REG_SCL3_BASE + 0xE7)
#define REG_SCL3_74_L        (REG_SCL3_BASE + 0xE8)
#define REG_SCL3_74_H        (REG_SCL3_BASE + 0xE9)
#define REG_SCL3_75_L        (REG_SCL3_BASE + 0xEA)
#define REG_SCL3_75_H        (REG_SCL3_BASE + 0xEB)
#define REG_SCL3_76_L        (REG_SCL3_BASE + 0xEC)
#define REG_SCL3_76_H        (REG_SCL3_BASE + 0xED)
#define REG_SCL3_77_L        (REG_SCL3_BASE + 0xEE)
#define REG_SCL3_77_H        (REG_SCL3_BASE + 0xEF)
#define REG_SCL3_78_L        (REG_SCL3_BASE + 0xF0)
#define REG_SCL3_78_H        (REG_SCL3_BASE + 0xF1)
#define REG_SCL3_79_L        (REG_SCL3_BASE + 0xF2)
#define REG_SCL3_79_H        (REG_SCL3_BASE + 0xF3)
#define REG_SCL3_7A_L        (REG_SCL3_BASE + 0xF4)
#define REG_SCL3_7A_H        (REG_SCL3_BASE + 0xF5)
#define REG_SCL3_7B_L        (REG_SCL3_BASE + 0xF6)
#define REG_SCL3_7B_H        (REG_SCL3_BASE + 0xF7)
#define REG_SCL3_7C_L        (REG_SCL3_BASE + 0xF8)
#define REG_SCL3_7C_H        (REG_SCL3_BASE + 0xF9)
#define REG_SCL3_7D_L        (REG_SCL3_BASE + 0xFA)
#define REG_SCL3_7D_H        (REG_SCL3_BASE + 0xFB)
#define REG_SCL3_7E_L        (REG_SCL3_BASE + 0xFC)
#define REG_SCL3_7E_H        (REG_SCL3_BASE + 0xFD)
#define REG_SCL3_7F_L        (REG_SCL3_BASE + 0xFE)
#define REG_SCL3_7F_H        (REG_SCL3_BASE + 0xFF)

#endif /* __HAL_PNL_REG_H__ */
